/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<string.h>
#include	"stream.h"
#include	"memory_debug.h"
#include	"netmapper.h"
#include	"xlerror.h"


XL_SEXP * xl_Netlist();

void
init_Netlist(XLISP_ENV* env)
{
	set_env(env,l_string(std_cm,"Netlist"),
		get_func_prim(xl_Netlist,FO_APPLICATIVE,0,2,2));
}

XL_SEXP * 
insert_src(NETLIST_VERTEX * v,XL_SEXP * el,XL_SEXP * x,XL_SEXP * y,XL_SEXP * s,NETLIST_WORK * w)
{
NETLIST_SRC * src,** sp;
	if ( get_type(el) != XLT_STRING )
		goto invalid_header_name;

	src = d_alloc(sizeof(*s));
	if ( el->string.data[0] == 0 )
		return 0;
	if ( v->point_name && l_strcmp(v->point_name,el->string.data) == 0 )
		return 0;

	src->filename = ll_copy_str(el->string.data);
	src->fileheader = ll_copy_str(w->fileheader);
	switch ( get_type(x) ) {
	case XLT_FLOAT:
		src->ptr.x = x->floating.data;
		break;
	case XLT_INTEGER:
		src->ptr.x = x->integer.data;
	case XLT_STRING:
		src->ptr.x = 0;
		sscanf(n_string(std_cm,x->string.data),"%f",&src->ptr.x);
		break;
	default:
		goto invalid_point;
	}
	switch ( get_type(y) ) {
	case XLT_FLOAT:
		src->ptr.y = y->floating.data;
		break;
	case XLT_INTEGER:
		src->ptr.y = y->integer.data;
		break;
	case XLT_STRING:
		src->ptr.y = 0;
		sscanf(n_string(std_cm,y->string.data),"%f",&src->ptr.y);
		break;
	default:
		goto invalid_point;
	}
	src->next = 0;
	sp = &v->src_list;
	for ( ; *sp ; sp = &(*sp)->next );
	*sp = src;
	return 0;
invalid_header_name:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Netlist"),
		List(n_get_string("string point name or filename is required"),
			n_get_string("data line No. is"),
			get_integer(el->h.line,0),-1));
invalid_point:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Netlist"),
		List(n_get_string("type missmatch point coordinate (floating or integer)"),
			n_get_string("data line No. is"),
			get_integer(el->h.line,0),-1));
}


XL_SEXP *
insert_vertex(NETLIST_WORK * w,XL_SEXP * lin,XL_SEXP * s)
{
NETLIST_VERTEX * v;
XL_SEXP * name,*x,*y;
XL_SEXP * ret;

ss_printf("INSERT VERTEX\n");
	name = car(lin);
	if ( get_type(name) != XLT_STRING ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"Netlist"),
			List(n_get_string("type missmatch first POINT name"),
				n_get_string("data line No. is"),
				get_integer(lin->h.line,0),-1));
	}
	for ( v = w->vertex ; v ; v = v->next )
		if ( l_strcmp(v->point_name,name->string.data) == 0 )
			break;
	if ( v == 0 ) {
		v = d_alloc(sizeof(*v));
		memset(v,0,sizeof(*v));
		v->next = w->vertex;
		w->vertex = v;
	}
	for ( ; get_type(lin) == XLT_PAIR ; ) {
		name = car(lin);
		lin = cdr(lin);
		x = car(lin);
		lin = cdr(lin);
		y = car(lin);
		lin = cdr(lin);
		ret = insert_src(v,name,x,y,s,w);
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	if ( v->point_name == 0 )
		v->point_name = ll_copy_str(v->src_list->filename);
	return 0;
}


XL_SEXP *
insert_tin(NETLIST_WORK * w,XL_SEXP * ln,XL_SEXP * s)
{
NETLIST_TIN * tin;
int ptr;
XL_SEXP * ptr_name;
NETLIST_VERTEX * v;
NETLIST_SRC * s1, * s2;
XL_SEXP * _line;

ss_printf("INSERT TIN\n");
	_line = ln;
	ptr = 0;
	tin = d_alloc(sizeof(*tin));
	memset(tin,0,sizeof(*tin));
	for ( ; get_type(ln) == XLT_PAIR ; ) {
		if ( ptr > 2 )
			break;
		ptr_name = car(ln);
		if ( get_type(ptr_name) == XLT_NULL ) {
			ln = cdr(ln);
			continue;
		}
		if ( get_type(ptr_name) != XLT_STRING ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"Netlist"),
				List(n_get_string("type missmatch first TIN POINT name"),
					n_get_string("data line No. is"),
					get_integer(_line->h.line,0),-1));
		}
		if ( l_strcmp(ptr_name->string.data,l_string(std_cm,"")) == 0 ) {
			ln = cdr(ln);
			continue;
		}
		for ( v = w->vertex ; v ; v = v->next )
			if ( l_strcmp(v->point_name,ptr_name->string.data) == 0 )
				break;
ss_printf("TIN-%ls %p\n",ptr_name->string.data,v);
		if ( v == 0 ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"Netlist"),
				List(n_get_string("type missmatch first TIN POINT is not exist"),
					get_string(ptr_name->string.data),
					n_get_string("data line No. is"),
					get_integer(_line->h.line,0),-1));
		}
		tin->vertex[ptr] = v;
		ln = cdr(ln);
		ptr++;
	}
ss_printf("TIN-ptr %i\n",ptr);
	if ( ptr == 0 )
		return 0;
	if (  ptr < 3 ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"Netlist"),
			List(n_get_string("too few TIN POINTst"),
				n_get_string("data line No. is"),
				get_integer(_line->h.line,0),-1));
	}
	for ( s1 = tin->vertex[0]->src_list->next ; s1 ; s1 = s1->next ) {
		tin->selects[0] = s1;
		for ( ptr = 1 ; ptr < 3 ; ptr ++ ) {
			for ( s2 = tin->vertex[ptr]->src_list->next ; s2 ; s2 = s2->next )
{
ss_printf("== %i %ls %ls\n",ptr,s1->filename,s2->filename);
				if ( l_strcmp(s1->filename,s2->filename) == 0 )
						break;
}
			if ( s2 == 0 )
				goto next;
			tin->selects[ptr] = s2;
		}
		if ( ptr == 3 )
			break;
	next:	;
	}
	if ( tin->selects[0] == 0 || tin->selects[1] == 0 || tin->selects[2] == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"Netlist"),
			List(n_get_string("correspond TIN POINT file is not exist"),
				get_string(tin->vertex[0]->point_name),
				get_string(tin->vertex[1]->point_name),
				get_string(tin->vertex[2]->point_name),
				n_get_string("data line No. is"),
				get_integer(_line->h.line,0),-1));
	tin->next = w->tins;
	w->tins = tin;
	return 0;
}

void
output_triangle(STREAM * st,NETLIST_WORK * w,NETLIST_TIN * t,NETLIST_POINT_LIST ** pp)
{
NETLIST_VERTEX * v;
int ptr;
NETLIST_POINT_LIST * ppp;
	for ( ptr = 0 ; ptr < 3 ; ptr ++ ) {
		v = t->vertex[ptr];
		for ( ppp = *pp ; ppp ; ppp = ppp->next )
			if ( l_strcmp(ppp->name,v->point_name) == 0 )
				goto next;
		ppp = d_alloc(sizeof(*ppp));
		ppp->name = ll_copy_str(v->point_name);
		ppp->next = *pp;
		*pp = ppp;
		s_printf(st,"  <point-map>%ls\n",v->point_name);
		s_printf(st,"     <list> %f %f </list>\n",
					t->selects[ptr]->ptr.x,
					t->selects[ptr]->ptr.y);
		s_printf(st,"     <list> %f %f </list>\n",
					v->src_list->ptr.x,
					v->src_list->ptr.y);
		s_printf(st,"  </point-map>\n");
	next:	;
	}
	s_printf(st,"  <triangle-map> %ls %ls %ls </triangle-map>\n",
		t->vertex[0]->point_name,
		t->vertex[1]->point_name,
		t->vertex[2]->point_name);
}

void
clear_point_list(NETLIST_POINT_LIST ** pp)
{
NETLIST_POINT_LIST * p;
	for ( ; *pp ; ) {
		p = *pp;
		*pp = p->next;
		d_f_ree(p->name);
		d_f_ree(p);
	}
}

XL_SEXP * 
save_mapfile(NETLIST_WORK * w,XL_SEXP * s)
{
NETLIST_TIN * t1,*t2;
STREAM * st;
char * filename;
int len,len2;
L_CHAR * _filename;
XL_SEXP * ret;
NETLIST_POINT_LIST * pp;

ss_printf("save\n");
	pp = 0;
	len = l_strlen(w->save_dir);
	for ( t1 = w->tins ; t1 ; t1 = t1->next ) {
//ss_printf("TIN\n");
		if ( t1->save_flag )
			continue;
		t1->save_flag = 1;
		_filename = t1->selects[0]->filename;
		len2 = l_strlen(_filename);
		filename = d_alloc((len + len2)*sizeof(L_CHAR)+10);
		sprintf(filename,"%s/%s.map",
			n_string(std_cm,w->save_dir),
			n_string(std_cm,_filename));
		st = s_open_file(filename,O_CREAT|O_TRUNC|O_RDWR,0644);
		if ( st == 0 ) {
			ret = get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_OPEN_FILE,
				l_string(std_cm,"Netlist"),
				List(n_get_string("cannot open the file "),
					n_get_string(filename),
					-1));
			d_f_ree(filename);
			return ret;
		}
		s_printf(st,"<?xl version=\"0.1\" encoding=\"UTF-8\"?>\n");
		s_printf(st,"<map>\n");
		s_printf(st,"  <meta>\n");
		s_printf(st,"    <file type=\"xl\"/>\n");
		s_printf(st,"    <src>%ls%ls%ls%ls</src>\n",
					w->src_filename_before,
					t1->selects[0]->fileheader,
					t1->selects[0]->filename,
					w->src_filename_after);
		s_printf(st,"    <dest>%ls</dest>\n",w->dest_filename);
		s_printf(st,"    <dp>1</dp>\n");
		s_printf(st,"  </meta>\n");
		output_triangle(st,w,t1,&pp);
		for ( t2 = t1->next ; t2 ; t2 = t2->next ) {
			if ( l_strcmp(t2->selects[0]->filename,t1->selects[0]->filename) )
				continue;
			t2->save_flag = 1;
			output_triangle(st,w,t2,&pp);
		}
		s_printf(st,"</map>\n");
		s_close(st);
		clear_point_list(&pp);
	}
	return 0;
}



XL_SEXP *
mapping_list(NETLIST_WORK * w)
{
	return 0;
}

XL_SEXP * 
xl_Netlist(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
NETLIST_WORK w;
L_CHAR * src;
L_CHAR * dest;
L_CHAR * save;
XL_SEXP * ret;
L_CHAR * p;
XL_SEXP * inp;
XL_SEXP * line;
XL_SEXP * el;
XL_SEXP * d;
L_CHAR fh;
int tin_mode;
	ret = 0;
	memset(&w,0,sizeof(w));

	src = get_sf_attribute(sf,l_string(std_cm,"src"));
	if ( src == 0 ) {
		ret = n_get_string("src attribute is required");
		goto invalid_param;
	}
	dest = get_sf_attribute(sf,l_string(std_cm,"dest"));
	if ( dest == 0 ) {
		ret = n_get_string("dest attribute is required");
		goto invalid_param;
	}
	save = get_sf_attribute(sf,l_string(std_cm,"save"));
	w.src_filename_before = ll_copy_str(src);
	for ( p = w.src_filename_before ; *p && *p != '*' ; p ++ );
	if ( *p == 0 ) {
		ret = n_get_string("src attribute requires URL path including wild car \"*\"");
		goto invalid_param;
	}
	*p = 0;
	w.src_filename_after = p+1;
	w.dest_filename = dest;
	w.save_dir = save;
	fh = 0;
	w.fileheader = &fh;
	inp = get_el(s,1);
	tin_mode = 0;
	for ( ; get_type(inp) == XLT_PAIR ; inp = cdr(inp) ) {
		line = car(inp);
print_sexp(s_stdout,line,0);
ss_printf("\n");
		el = car(line);
		if ( get_type(el) != XLT_STRING )
			continue;
		if ( el->string.data[0] == '#' )
			continue;
		if ( el->string.data[0] == 0 && tin_mode == 0 )
			continue;
		if ( l_strcmp(el->string.data,l_string(std_cm,"tin")) == 0 ) {
			tin_mode = 1;
			continue;
		}
		if ( l_strcmp(el->string.data,l_string(std_cm,"point")) == 0 ) {
			tin_mode = 0;
			continue;
		}
		if ( l_strcmp(el->string.data,l_string(std_cm,"fileheader")) == 0 ) {
			d = get_el(line,1);
			if ( get_type(d) != XLT_STRING ) {
				ret = n_get_string("invalid fileheader");
				goto invalid_param;
			}
			w.fileheader = d->string.data;
		}
		if ( tin_mode == 0 )
			ret = insert_vertex(&w,line,s);
		else	ret = insert_tin(&w,line,s);
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	if ( w.save_dir ) {
		ret = save_mapfile(&w,s);
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	return mapping_list(&w);
invalid_param:

	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Netlist"),
		ret);
}


