/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"


XL_SEXP * xl_GetXLIinfo();

void
init_GetXLIinfo(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetXLIinfo"),
		get_func_prim(xl_GetXLIinfo,FO_APPLICATIVE,0,2,2));
}


XL_SEXP *
info_formating(XL_INTERPRETER * xli)
{
	return List(n_get_symbol("xli-info"),
		List(n_get_symbol("iid"),
			get_integer(xli->id,0),
			-1),
		List(n_get_symbol("mode"),
			get_integer(xli->mode,0),
			-1),
		List(n_get_symbol("front-thread-id"),
			get_integer(xli->front_thread,0),
			-1),
		List(n_get_symbol("relay-thread-id"),
			get_integer(xli->relay_thread,0),
			-1),
		List(n_get_symbol("connection-count"),
			get_integer(xli->connection_cnt,0),
			-1),
		List(n_get_symbol("flags"),
			get_integer(xli->flags,0),
			-1),
		List(n_get_symbol("open-timeout"),
			get_integer(xli->open_timeout,0),
			-1),
		List(n_get_symbol("ip"),
			get_integer(xli->ip,0),
			-1),
		List(n_get_symbol("port"),
			get_integer(xli->port,0),
			-1),
		List(n_get_symbol("hostname"),
			get_string(xli->hostname),
			-1),
		List(n_get_symbol("connection-timeout"),
			get_integer(xli->connection_timeout,0),
			-1),
		List(n_get_symbol("silent-timeout"),
			get_integer(xli->silent_timeout,0),
			-1),
		List(n_get_symbol("delay-que-count"),
			get_integer(xli->delay_que_cnt,0),
			-1),
		-1);
}


XL_SEXP *
xl_GetXLIinfo(XLISP_ENV * env,XL_SEXP * s)
{
XL_INTERPRETER buf;
XL_SEXP * iid;
	iid = get_el(s,1);
	if ( get_type(iid) != XLT_INTEGER )
		goto type_missmatch;
	if ( get_xli_info(&buf,iid->integer.data) < 0 )
		goto no_obj;
	return info_formating(&buf);

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetXLIinfo"),
		n_get_string("type missmatch IID"));
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"GetXLIinfo"),
		n_get_string("undefined IID"));
}



