/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_Reverse();

void
init_Reverse(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Reverse"),
		get_func_prim(xl_Reverse,FO_APPLICATIVE,0,2,2));
}


XL_SEXP *
reverse(XL_SEXP * s)
{
XL_SEXP * ret;
	ret = 0;
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) )
		ret = cons(car(s),ret);
	return ret;
}

XL_SEXP *
xl_Reverse(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * p;
XL_SEXP * ret;
	p = get_el(s,1);
	ret = 0;
	for ( ; get_type(p) == XLT_PAIR ; p = cdr(p) )
		ret = cons(car(p),ret);
	return ret;
}

