/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"memory_debug.h"
#include	"memory_routine.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"mlong_char.h"


XL_SEXP *
get_uenv_sexp(UNIT_ENV * ue)
{
	return 0;
}

XL_SEXP *
get_element_sexp(ELEMENT * el)
{
	return List(n_get_symbol("element"),
		get_string(el->sym),
		el->data,
		-1);
}


XL_SEXP *
get_hash_sexp(ELEMENT ** hash)
{
int i;
XL_SEXP * ret;
ELEMENT * el;
	ret = 0;
	for ( i = 0 ; i < ENV_HASH_SIZE ; i ++ ) {
		for ( el = hash[i] ; el ; el = el->next )
			ret = cons(get_element_sexp(el),ret);
	}
	return ret;
}

XL_SEXP *
get_listbase_env(XLISP_ENV * e)
{
XL_SEXP * ret;
	switch ( e->type ) {
	case GBET_PAIR:
		return List(n_get_symbol("xlisp-env"),
			List(n_get_symbol("type"),
				n_get_string("pair"),
				-1),
			(e->p.env[0]==0 ? 0: get_env(e->p.env[0])),
			(e->p.env[1]==0 ? 0: get_env(e->p.env[1])),
			-1);
	case GBET_ENV:
		ret = List(n_get_symbol("xlisp-env"),
			List(n_get_symbol("type"),
				n_get_string("env"),
				-1),
			List(n_get_symbol("parent"),
				(e->e.parent == 0 ? 0 : get_env(e->e.parent)),
				-1),
			List(n_get_symbol("work"),
				get_integer((INTEGER64)(int)e->e.work,0),
				-1),
			List(n_get_symbol("flags"),
				get_integer(e->e.flags,0),
				-1),
			cons(n_get_symbol("hash"),
				get_hash_sexp(e->e.hash)),
			-1);
		if ( e->e.uenv )
			ret = append(ret,
			cons(List(n_get_symbol("uenv"),
				get_uenv_sexp(e->e.uenv),
				-1),0));
		if ( e->e.default_sym )
			ret = append(ret,
				cons(List(n_get_symbol("default-sym"),
					get_element_sexp(e->e.default_sym),
					-1),0));
		return ret;
	default:
		er_panic("get_listbase_env");
		return 0;
	}
}

