// ===========================================================================
//	UQuickTime.h				PowerPlant 2.2.1	1994-2000 Metrowerks Inc.
// ===========================================================================

#ifndef _H_UQuickTime
#define _H_UQuickTime
#pragma once

#include <LPane.h>
#include <LPeriodical.h>

#include <Movies.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ===========================================================================
//	 UQuickTime 
// ===========================================================================

class	UQuickTime {
public:
	static bool		QuickTimeIsPresent();
	static void		Initialize();
	static void		Finalize();

	static Movie	GetMovieFromFile();
	static void		SaveFlattenedMovie( Movie inMovie );
};


// ===========================================================================
//	 LMovieController 
// ===========================================================================

class	LMovieController : public LPane,
						   public LPeriodical {
public:
						LMovieController();

						LMovieController(
								const SPaneInfo &inPaneInfo,
								Movie inMovie);

	virtual				~LMovieController();

	virtual void		SpendTime( const EventRecord &inMacEvent );

protected:
	Movie				mMovie;
	MovieController		mMovieController;

	virtual void		DrawSelf();
};


PP_End_Namespace_PowerPlant

#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
