/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


extern "C" {
#include "memory_debug.h"
#include "task.h"
#include "pri_level.h"
}

#include "LThread.h"
#include "v/v.h"


extern "C" {
void _call__main();
void call__main();
void _call_ipc_system(TKEY key);
void call_ipc_system(const char *path);
void ipc_system(int argc,char ** argv);
int _main(int argc,char ** argv);
extern bool	startup_flag;


// ===========================================================================
//	mac_cosmos.cp		COSMOS Startup for Macintosh by Tomoki Sekiyama
// ===========================================================================


void _call__main()
{
	v_open_file_callback = call_ipc_system;

	char *argv[2];
	argv[0] = copy_str("cosmos");
	argv[1] = copy_str("v");
	_main(2,argv);
}

void call__main()
{
	create_task((void(*)())_call__main, 0, PRI_TOOLKIT);
}

void _call_ipc_system(TKEY key)
{
	char *argv[3];

	static SEM call_ipc_lock = new_lock(0);
	argv[0] = "cosmos";
	argv[1] = "ev";
	argv[2] = (char *)GET_TKEY(key);
	
	lock_task(call_ipc_lock);
	while ( !startup_flag )
{
ss_printf("SLEEP %i\n",startup_flag);
		LThread::GetCurrentThread()->Sleep(100);
ss_printf("SLEEP-2 %i\n",startup_flag);
}
	printf("Open File : %s\n", argv[2]);
	ipc_system(3, argv);
	unlock_task(call_ipc_lock, "call_ipc_system");
	d_f_ree(argv[2]);
}

void call_ipc_system(const char *path)
{

ss_printf("==================== CALLBACK\n");
	create_task((void(*)())_call_ipc_system, (int)copy_str((char*)path), PRI_IPC_TASK);
}

} // extern "C"
