/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"utils.h"
#include	"time.h"

#define DATETIME_2001_1_1_0_00_00 3061152000  // 1904.1.1 0:00:00 - 2001.1.1 0:00:00

int
get_xltime()
{
unsigned long ret;
	GetDateTime(&ret);
	return  ret - DATETIME_2001_1_1_0_00_00;
}

char *
get_xltime_str(unsigned int t,int format)
{
unsigned long tt;
DateTimeRec a;
Str255 ret;
	switch ( format ) { 
	case TFMT_UNIX:
		tt = t + UTC_00_00_00_01_01_2001;
		return copy_str(ctime(&tt));
	case TFMT_W3C_DTF:
		tt = t + DATETIME_2001_1_1_0_00_00;
		SecondsToDate(tt, &a);
		sprintf(ret,"%04i-%02i-%02i",a.year, a.month, a.day);
		return copy_str(ret);
	default:
		return 0;
	}
}


