/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "PP_Prefix.h"
#include "machine/v_types2.h"

#include "LTextGroupBox.h"

#include "machine/v_types.h"
#include "v/VGroupBox.h"
#include "v/VLayout.h"
#include "CClickCheckAttachment.h"

extern "C" void er_panic(char*);



VExError
VGroupBox::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	sts.attr = 0;
	if ( flags & VSF_ATTR )
		sts.attr = s->attr;

	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	SViewInfo viewInfo = { (SDimension32){0,0}, {0,0}, {8,8}, false };
	LTextGroupBox *v = new LTextGroupBox(paneInfo, viewInfo, sts.attr==primary);
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	info = v;
	return nmp->add_child_do(this);
}

void
VGroupBox::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	delete info;
	nmp->redraw();
}

VGroupBox::~VGroupBox()
{
}

VExError
VGroupBox::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VGroupBox::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS) ) {
		v_set_descriptor(info, sts.descriptor, sts.ws, sts.fsize, sts.vert_desc, &sts.min_size);
		err.subcode1 &= ~ (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS);
	}

	if ( flags & VSF_CALC_MIN ) {
		if (sts.children)
			sts.children->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		if ( sts.descriptor && sts.descriptor[0] != 0 )
			layout.set_margin((VSize){3,16}, (VSize){3,3});
		else
			layout.set_margin((VSize){3,3}, (VSize){3,3});
		layout.layout_in_frame(this, true);
		sts.min_size = layout.parent_min_size();
		err.subcode1 &= ~ VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		if ( sts.descriptor && sts.descriptor[0] != 0 )
			layout.set_margin((VSize){3,16}, (VSize){3,3});
		else
			layout.set_margin((VSize){3,3}, (VSize){3,3});
		layout.layout_in_frame(this);
		layout.do_layout(this);
		err.subcode1 &= ~ VSF_LAYOUT;
	}

	V_OP_END

	if ( flags & (VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

VExError
VGroupBox::add_child_do(VObject* child)
{
	VLayout layout;	// calc min size
	layout.layout_in_frame(this, true);
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VGroupBox::remove_child_do(VObject* child)
{
	// do nothing
}

void
VGroupBox::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VGroupBox::redraw(VRect* rect) const
{
	_V_OP_START()
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	V_OP_END
}
