/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
		Atsushi MURAMATSU <muramatsu@s-cradle.com>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"


extern THREAD_BLOCK	tb[THREAD_BLOCK_SIZE];
extern THREAD_BLOCK *	tb_free_list;

D_SEM	block_lock;



void
init_thread_block()
{
int i;
D_SEM s;
	s = &tb[0].sem;
	sem_init(s,0,1);
	sem_trywait(s);
	sem_post(s);
	block_lock = s;
	_lock_task(block_lock,__FILE__,__LINE__);
	for ( i = 1 ; i < THREAD_BLOCK_SIZE ; i ++ ) {
		tb[i].next = tb_free_list;
		tb_free_list = &tb[i];
	}
	_unlock_task(block_lock,"init_thread_block",__FILE__,__LINE__);
}
