/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>

#include	"serial_port.h"
#include	"memory_debug.h"
#include	"utils.h"

int	serial_port_list_ready = 0;
SERIAL_PORT_INFO *	serial_port_list = 0;

#if 0

SERIAL_PORT_INFO *
lookup_serial_port()
{
FILE *p;
char buffer[80];

	if ( serial_port_list_ready )
		return serial_port_list;
	serial_port_list_ready = 1;
	
	p = popen("ls /dev/cu*", "r");
	if ( p == 0 ) {
		perror("popen");
		return 0;
	}
	while ( fgets(buffer, sizeof(buffer), p) ) {
		SERIAL_PORT_INFO *port = d_alloc(sizeof(SERIAL_PORT_INFO));
		port->next = serial_port_list;
		serial_port_list = port;
		
		buffer[strlen(buffer)-1] = 0;
		port->info = port->name = copy_str(buffer);
	}
	pclose(p);
	return serial_port_list;
}

#else

#include	<CoreFoundation/CoreFoundation.h>

#include	<IOKit/IOKitLib.h>
#include	<IOKit/serial/IOSerialKeys.h>
#include	<IOKit/IOBSD.h>

kern_return_t
createSerialIterator(io_iterator_t *serialIterator)
{
	kern_return_t	kernResult;
	mach_port_t		masterPort;
	CFMutableDictionaryRef	classesToMatch;
	if ( (kernResult=IOMasterPort(0, &masterPort)) != KERN_SUCCESS ) {
		printf("IOMasterPort returned %d\n", kernResult);
		return kernResult;
	}
	if ( (classesToMatch = IOServiceMatching(kIOSerialBSDServiceValue)) == NULL ) {
		printf("IOServiceMatching returned NULL\n");
		return kernResult;
	}
	CFDictionarySetValue(classesToMatch, CFSTR(kIOSerialBSDTypeKey),
		CFSTR(kIOSerialBSDRS232Type));
	kernResult = IOServiceGetMatchingServices(masterPort, classesToMatch, serialIterator);
	if ( kernResult != KERN_SUCCESS ) {
		printf("IOServiceGetMatchingServices returned %d\n", kernResult);
	}
	return kernResult;
}

char *
getRegistryString(io_object_t sObj, char *propName)
{
	static char resultStr[256];
	CFTypeRef	nameCFstring;
	resultStr[0] = 0;
	nameCFstring = IORegistryEntryCreateCFProperty(sObj,
		CFStringCreateWithCString(kCFAllocatorDefault, propName, kCFStringEncodingASCII),
			kCFAllocatorDefault, 0);
	if (nameCFstring) {
		CFStringGetCString(nameCFstring, resultStr, sizeof(resultStr),
			kCFStringEncodingASCII);
		CFRelease(nameCFstring);
	}
	return resultStr;
}


SERIAL_PORT_INFO *
lookup_serial_port()
{
io_iterator_t	theSerialIterator;
io_object_t		theObject;
//char	ttyDevice[256], callOutDevice[256];
	
	if ( serial_port_list_ready )
		return serial_port_list;
	serial_port_list_ready = 1;
	
	if ( createSerialIterator(&theSerialIterator) != KERN_SUCCESS ) {
		printf("createSerialIterator failed\n");
		return 0;
	}
	while ( (theObject = IOIteratorNext(theSerialIterator)) ) {
		SERIAL_PORT_INFO *port = d_alloc(sizeof(SERIAL_PORT_INFO));
		port->next = serial_port_list;
		serial_port_list = port;
		
		port->name = copy_str(getRegistryString(theObject, kIOTTYDeviceKey));
		// getRegistryString(theObject, kIODialinDeviceKey);
		port->info = copy_str(getRegistryString(theObject, kIOCalloutDeviceKey));
	}
	return serial_port_list;
}

#endif