/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<sys/wait.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<signal.h>
#include	<errno.h>
#include	"init.h"
#include	"task.h"
#include	"utils.h"

void sigalarm_handler();
void sigpipe_handler();
void sigint_handler();
void siglwp_handler();

extern int task_flags;




void
set_ignore_chld()
{
	sigignore(SIGCHLD);
}

void
all_signal_mask_posix()
{
	all_signal_mask(1,45);
}

void
set_alarm_mask(int flags)
{
	all_signal_mask_posix();
	signal(SIGALRM,sigalarm_handler);
	signal(SIGPIPE,sigpipe_handler);
	signal(SIGLWP,siglwp_handler);
	signal(SIGINT,sigint_handler);
	task_flags = flags;
	if ( (flags&INI_THREAD) == INI_DONTWAITCHI )
		set_ignore_chld();
}
