/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <stdio.h>
#include "utils.h"
#include "task.h"
#include "lock_level.h"
#include "machine/msequence.h"
#include "task.h"

// mori
int mseq_flag;
int mseq_flag2;

SEM mseq_que_lock;
MS_INFO * ms_info_head[PRI_MAX];
MS_INFO * ms_info_tail[PRI_MAX];
int loop_task_id;
void (*ms_put_call_back)(int (*func)(), void * arg, char str[]) = 0;
void (*ms_done_call_back)(int (*func)(), void * arg, char str[]) = 0;
int ms_lock_cnt;
char * ms_lock_file;
int ms_lock_line;
int ms_lock_tid;


MS_INFO * ms_processed;

void
init_msequence()
{
int i;

	loop_task_id = get_tid();
	mseq_que_lock = new_lock(LL_MSEQUENCE);
	for ( i = 0; i < PRI_MAX ; i ++ ) {
		ms_info_head[i] = 0;
		ms_info_tail[i] = 0;
	}

	mseq_flag = 1;
}

int get_userinterface_tid()
{
	return loop_task_id;
}


void
ms_loop()
{
MS_INFO * ms;
int pri;
	mseq_flag2 = 1;
	for ( ; ; ) {
		lock_task(mseq_que_lock);
		for ( pri = PRI_MAX-1 ; pri >= 0 ; pri -- )
			if ( ms_info_head[pri] )
				break;
		if ( pri < 0 ) {
			sleep_task((int)&mseq_que_lock,
				mseq_que_lock);
			continue;
		}
		ms = ms_info_head[pri];
		ms_info_head[pri] = ms->next;
		if ( ms_info_head[pri] == 0 )
			ms_info_tail[pri] = 0;
		ms_processed = ms;
		unlock_task(mseq_que_lock, "ms_loop");

		ms->result = (*ms->func)(ms->arg);

		lock_task(mseq_que_lock);
		ms->func = 0;
		ms_processed = 0;
		wakeup_task((int)ms);
		wakeup_task((int)&ms_lock_cnt);
		unlock_task(mseq_que_lock,"ms_loop");
	}
}


static void
ms_put_func(MS_INFO * ms)
{
int pri;

	pri = get_pri(0);
	ms->next = 0;
	if ( ms_info_tail[pri] == 0 ) {
		ms_info_tail[pri] = ms_info_head[pri] = ms;
	}
	else {
		ms_info_tail[pri]->next = ms;
		ms_info_tail[pri] = ms;
	}
}



int
ms_do(int (*func)(), void * arg,int cb_flag, char str[])
{
MS_INFO ms;
	if ( mseq_flag == 0 ) {
		er_panic("????\n");
		exit(1);
	}
	if ( loop_task_id == get_tid() || mseq_flag2 == 0 )
		return  (*func)(arg);
	ms.func = func;
	ms.arg = arg;
	strcpy(ms.str,str);

	lock_task(mseq_que_lock);
	ms_put_func(&ms);
	if ( ms_put_call_back && cb_flag )
		(*ms_put_call_back)(func,arg,str);
	wakeup_task((int)&mseq_que_lock);
	for ( ; ms.func ; ) {
		sleep_task((int)&ms,mseq_que_lock);
		lock_task(mseq_que_lock);
	}
	if ( ms_done_call_back && cb_flag ) {
		(*ms_done_call_back)(func,arg,str);
	}
	unlock_task(mseq_que_lock, "ms_do");
	return ms.result;
}

