/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<sys/types.h>
#include	<sys/stat.h>
#include	"u_file.h"
#include	"utils.h"
#include	"memory_debug.h"

int
u_stat(char * path,U_STAT * buf)
{
int ret;
struct stat64_t _buf;
char * _path;
	_path = change_delim_str(path);
	ret = _stat64(_path,&_buf);
	if ( _path != path )
		d_f_ree(_path);
	if ( ret < 0 )
		return ret;
	buf->us_mtime = 
	  _buf.st_mtime - UTC_00_00_00_01_01_2001;
	buf->us_atime = 
	  _buf.st_atime - UTC_00_00_00_01_01_2001;
	buf->us_ctime = 
	  _buf.st_ctime - UTC_00_00_00_01_01_2001;
	buf->us_mode = _buf.st_mode;
	buf->us_uid = _buf.st_uid;
	buf->us_gid = _buf.st_gid;
	return 0;
}
