/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<windows.h>
#include	<commdlg.h>
#include	"v/v_serialized_exec.h"
#include	"v/VChooseFile.h"

extern "C" {
#include	"utils.h"
#include	"memory_debug.h"

static char *
_v_choose_file(const L_CHAR *title, const char *default_path)
{
	static OPENFILENAME ofn;
	static char szFn[256], szFt[256], str[280];
	char *def = default_path ? change_delim_str(default_path) : 0;

	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFilter = "All Files (*.*)\0*.*\0\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFn;
	ofn.nMaxFile = sizeof(szFn);
	ofn.lpstrFileTitle = szFt;
	ofn.nMaxFileTitle = sizeof(szFt);
	ofn.lpstrInitialDir = def;
	ofn.Flags = OFN_FILEMUSTEXIST;

	if ( GetOpenFileName(&ofn) ) {
		char *ret = normalize_delim_str(szFn);
		if ( def )
			d_f_ree(def);
		return ret;
	}

	if ( def )
		d_f_ree(def);
	return 0;
}

char *
v_choose_file(const L_CHAR *title, const char *default_path)
{
	return v_serialized_exec_func(_v_choose_file, title, default_path);
}

}
