/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"


void
init_gmx_format(XLISP_ENV * gmxEnv)
{
XLISP_ENV * gmxMatrixParamEnv;

	gmxMatrixParamEnv = new_env(0);
	set_env(gmxEnv,l_string(std_cm,"gmxMatrixParam"),
		get_func_prim(gb_gmxMatrixParam,FO_NORMAL,gmxMatrixParamEnv,1,-1));
	set_env(gmxMatrixParamEnv,l_string(std_cm,"gmxPriority"),
		get_func_prim(gb_gmxPriority,FO_APPLICATIVE,0,1,1));
	

	set_env(gmxEnv,l_string(std_cm,"gmxMatrixDimDivide"),
		get_func_prim(gb_gmxMatrixDimDivide,FO_APPLICATIVE,0,1,1));
	set_env(gmxEnv,l_string(std_cm,"gmxMatrixBlockSize"),
		get_func_prim(gb_gmxMatrixBlockSize,FO_APPLICATIVE,0,1,1));
	set_env(gmxEnv,l_string(std_cm,"gmxMatrixPixelSize"),
		get_func_prim(gb_gmxMatrixPixelSize,FO_APPLICATIVE,0,1,1));
	set_env(gmxEnv,l_string(std_cm,"gmxChannelInfo"),
		get_func_prim(gb_gmxChannelInfo,FO_APPLICATIVE,0,1,2));
	set_env(gmxEnv,l_string(std_cm,"gmxPhase"),
		get_func_prim(gb_gmxPhase,FO_NORMAL,0,1,-1));
}

XL_SEXP *
set_gc_bind(XLISP_ENV * e,XL_SEXP * s)
{
XL_SEXP * ret;
XL_SEXP * sym;
	ret = eval(e,sym=n_get_symbol("____gc_bind"));
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	set_op(e,sym,cons(s,ret));
	return 0;
}


int
save_mode_cal_sexp(MATRIX * m,int mode,XL_SEXP ** phase)
{
char * mode_phase_org[MI_MAX*2];
char ** mode_phase[MI_MAX];
int i;
STREAM * st;
int ret;
	for ( i = 0 ; i < MI_MAX ; i ++ ) {
		if ( phase[i] ) {
			mode_phase[i] = &mode_phase_org[2*i];
			mode_phase_org[2*i + 1] = 0;
			st = s_open_string_write(&utf8_cm);
			print_sexp(st,phase[i],PF_MULTI_ROOT);
			mode_phase_org[2*i] = copy_str(s_get_string(st));
			s_close(st);
		}
		else {
			mode_phase_org[2*i] = 0;
			mode_phase[i] = 0;
		}
	}
	ret = save_mode_cal(m,mode,mode_phase,0);
	for (  i = 0 ; i < MI_MAX ; i ++ ) {
		if ( mode_phase_org[2*i]  )
			d_f_ree(mode_phase_org[2*i]);
	}
	return ret;
}

XL_SEXP *
gb_gmxPhase(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
CREATE_WORK * cw;
MATRIX * mtx;
L_CHAR * no;
L_CHAR * equ;
L_CHAR * mode;
L_CHAR * type;
char * e_msg;
int er;
int _mode;
int _equ;
int _no;
	cw = get_env_work(env);
	if ( cw == 0 )
		goto inv_format;
	mtx = cw->mtx;
	no = get_sf_attribute(sf,l_string(std_cm,"area"));
	if ( no == 0 ) {
		e_msg = "area";
		goto inv_param;
	}
	_no = atoi(n_string(std_cm,no));
	if ( _no < 0 || _no >= MI_MAX ) {
		e_msg = "no value boundary";
		goto inv_param;
	}
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	mode = get_sf_attribute(sf,l_string(std_cm,"mode"));
	if ( mode == 0 ||(l_strcmp(mode,l_string(std_cm,"active")) == 0) ) {
		if ( type == 0 )
			goto default_type;
		if ( l_strcmp(type,l_string(std_cm,"equ")) == 0 ) {
			equ = get_sf_attribute(sf,l_string(std_cm,"equ"));
			if ( equ == 0 ) {
				e_msg = "equ";
				goto inv_param;
			}
			_equ = atoi(n_string(std_cm,equ));
			if ( _equ < 0 || _equ >= MI_MAX ) {
				e_msg = "equ value boundary";
				goto inv_param;
			}
			er = set_matrix_cal_equ(mtx,
				atoi(n_string(std_cm,no)),
				atoi(n_string(std_cm,equ)));
			if ( er < 0 )
				return get_error(
					s->h.file,
					s->h.line,
					XLE_PROTO_UNSUTISFIED_INFO,
					l_string(std_cm,"gmxCreate/gmxPhase"),
					get_integer(er,0));
		}
		else {
		default_type:
			s = gb_quote_trace(env,cdr(s),type);
			if ( get_type(s) == XLT_ERROR )
				return s;
			set_gc_bind(env,s);
			er = set_matrix_cal(mtx,atoi(n_string(std_cm,no)),s);
			if ( er < 0 )
				return get_error(
					s->h.file,
					s->h.line,
					XLE_PROTO_UNSUTISFIED_INFO,
					l_string(std_cm,"gmxCreate/gmxPhase"),
					get_integer(er,0));
		}
	}
	else {
		if ( l_strcmp(mode,l_string(std_cm,"direct")) == 0 )
			_mode = MI_MODE_DIRECT;
		else if ( l_strcmp(mode,l_string(std_cm,"server")) == 0 )
			_mode = MI_MODE_SERVER;
		else if ( l_strcmp(mode,l_string(std_cm,"client")) == 0 )
			_mode = MI_MODE_CLIENT;
		else {
			e_msg = "mode value";
			goto inv_param;
		}
		if ( type == 0 )
			goto default_type2;
		if ( l_strcmp(type,l_string(std_cm,"equ")) == 0 ) {
			equ = get_sf_attribute(sf,l_string(std_cm,"equ"));
			if ( equ == 0 ) {
				e_msg = "equ";
				goto inv_param;
			}
			_equ = atoi(n_string(std_cm,equ));
			if ( _equ < 0 || _equ >= MI_MAX ) {
				e_msg = "equ value boundary";
				goto inv_param;
			}
			cw->phase_active[_mode] = 1;
			cw->phase[_mode][_no] = cw->phase[_mode][_equ];
					}
		else {
		default_type2:
			s = gb_quote_trace(env,cdr(s),type);
			if ( get_type(s) == XLT_ERROR )
				return s;
			cw->phase_active[_mode] = 1;
			cw->phase[_mode][_no] = s;
		}
	}
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxPhase"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxPhase"),
		n_get_string(e_msg));
}



XL_SEXP *
gb_gmxChannelInfo(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
CREATE_WORK * cw;
MATRIX * mtx;
L_CHAR * type;
L_CHAR * flag;
char * e_msg;
int er;
MATRIX_CHANNEL_INFO inf;
MATRIX_DATA_TYPE * tp;
int cnt;
XL_SEXP * dd;
int size;

float fp;
double dp;
char char_p;
short short_p;
int int_p;
L_CHAR * channel;
INTEGER64 long_p;
	cw = get_env_work(env);
	if ( cw == 0 )
		goto inv_format;
	mtx = cw->mtx;
	if ( cw->mode != MXEM_CREATE )
		return 0;
	channel = get_sf_attribute(sf,l_string(std_cm,"channel"));
	if ( channel == 0 ) {
		e_msg = "channel";
		goto inv_param;
	}
	memset(&inf,0,sizeof(inf));
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	if ( type == 0 ) {
		e_msg = "type";
		goto inv_param;
	}
	for ( cnt = 0  ; cnt < MDT_MAX ; cnt ++  ) {
		if ( mtx_type_tbl[cnt] == 0 )
			continue;
		if ( l_strcmp(type,l_string(std_cm,mtx_type_tbl[cnt]->type_name)) == 0 )
			goto next1;
	}
	e_msg = "invalid type(type)";
	goto inv_param;
next1:
	tp = mtx_type_tbl[cnt];
	inf.data_type = tp;
	inf.default_data = 0;
	flag = get_sf_attribute(sf,l_string(std_cm,"send"));
	if ( flag && (l_strcmp(flag,l_string(std_cm,"on")) == 0) )
		inf.flags |= MF_SEND;
	flag = get_sf_attribute(sf,l_string(std_cm,"file"));
	if ( flag && (l_strcmp(flag,l_string(std_cm,"on")) == 0) )
		inf.flags |= MF_FILE;
	flag = get_sf_attribute(sf,l_string(std_cm,"visu"));
	if ( flag && (l_strcmp(flag,l_string(std_cm,"on")) == 0) )
		inf.flags |= MF_VISU;
	flag = get_sf_attribute(sf,l_string(std_cm,"send_visu"));
	if ( flag && (l_strcmp(flag,l_string(std_cm,"on")) == 0) )
		inf.flags |= MF_SEND_VISU;
	flag = get_sf_attribute(sf,l_string(std_cm,"send_file"));
	if ( flag && (l_strcmp(flag,l_string(std_cm,"on")) == 0) )
		inf.flags |= MF_SEND_FILE;

	if ( list_length(s) == 1 )
		goto next2;
	dd = get_el(s,1);
	if ( tp->parent )
		size = (*tp->parent->get_size)(tp->parent,0);
	else	size = (*tp->get_size)(tp,0);
	switch ( get_type(dd) ) {
	case XLT_INTEGER:
		switch ( (tp->type & MDT_BASE_TYPE) ) {
		case MDT_FLOAT:
			fp = dd->integer.data;
			inf.default_data = &fp;
			break;
		case MDT_DOUBLE:
			dp = dd->integer.data;
			inf.default_data = &dp;
			break;
		case MDT_BLOCK:
		case MDT_STRING:
		case MDT_SEXP:
			goto type_missmatch;
		}
		switch ( size ) {
		case 1:
			char_p = dd->integer.data;
			inf.default_data = &char_p;
			break;
		case 2:
			short_p = dd->integer.data;
			inf.default_data = &short_p;
			break;
		case 4:
			int_p = dd->integer.data;
			inf.default_data = &int_p;
			break;
		case 8:
			inf.default_data = &dd->integer.data;
			break;
		default:
			goto type_missmatch;
		}
		break;
	case XLT_FLOAT:
		switch ( (tp->type & MDT_BASE_TYPE) ) {
		case MDT_FLOAT:
			fp = dd->floating.data;
			inf.default_data = &fp;
			break;
		case MDT_DOUBLE:
			dp = dd->floating.data;
			inf.default_data = &dp;
			break;
		case MDT_BLOCK:
		case MDT_STRING:
		case MDT_SEXP:
			goto type_missmatch;
		}
		switch ( size ) {
		case 1:
			char_p = dd->floating.data;
			inf.default_data = &char_p;
			break;
		case 2:
			short_p = dd->floating.data;
			inf.default_data = &short_p;
			break;
		case 4:
			int_p = dd->floating.data;
			inf.default_data = &int_p;
			break;
		case 8:
			long_p = dd->floating.data;
			inf.default_data = &long_p;
			break;
		default:
			goto type_missmatch;
		}
		break;
	case XLT_STRING:
		if ( (tp->type & MDT_BASE_TYPE) != MDT_STRING )
			goto type_missmatch;
		inf.default_data = dd->string.data;
		break;
	default:
		goto type_missmatch;
	}
next2:
	er = set_matrix_channel_info(mtx,atoi(n_string(std_cm,channel)),&inf);
	if ( er < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUTISFIED_INFO,
			l_string(std_cm,"gmxCreate/gmxChannelInfo"),
			get_integer(er,0));
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxChannelInfo"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxChannelInfo"),
		n_get_string(e_msg));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxCreate/gmxChannelInfo"),
		0);


}


XL_SEXP *
gb_gmxMatrixPixelSize(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
CREATE_WORK * cw;
MATRIX * mtx;
L_CHAR * pixel_size;
L_CHAR * dim;
char * e_msg;
int er;
	cw = get_env_work(env);
	if ( cw == 0 )
		goto inv_format;
	mtx = cw->mtx;
	if ( cw->mode != MXEM_CREATE )
		return 0;
	dim = get_sf_attribute(sf,l_string(std_cm,"dim"));
	if ( dim == 0 ) {
		e_msg = "dim";
		goto inv_param;
	}
	pixel_size = get_sf_attribute(sf,l_string(std_cm,"value"));
	if ( pixel_size == 0 ) {
		e_msg = "value";
		goto inv_param;
	}
	er = set_matrix_pixel_size(mtx,
		atoi(n_string(std_cm,dim)),
		atoi(n_string(std_cm,pixel_size)));
	if ( er < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUTISFIED_INFO,
			l_string(std_cm,"gmxCreate/gmxMatrixPixelSize"),
			get_integer(er,0));
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxMatrixPixelSize"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxMatrixPixelSize"),
		n_get_string(e_msg));
}


XL_SEXP *
gb_gmxMatrixBlockSize(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
CREATE_WORK * cw;
MATRIX * mtx;
L_CHAR * block_size;
L_CHAR * dim;
char * e_msg;
int er;
	cw = get_env_work(env);
	if ( cw == 0 )
		goto inv_format;
	mtx = cw->mtx;
	if ( cw->mode != MXEM_CREATE )
		return 0;
	dim = get_sf_attribute(sf,l_string(std_cm,"dim"));
	if ( dim == 0 ) {
		e_msg = "dim";
		goto inv_param;
	}
	block_size = get_sf_attribute(sf,l_string(std_cm,"value"));
	if ( block_size == 0 ) {
		e_msg = "value";
		goto inv_param;
	}
	er = set_matrix_block_size(mtx,
		atoi(n_string(std_cm,dim)),
		atoi(n_string(std_cm,block_size)));
	if ( er < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUTISFIED_INFO,
			l_string(std_cm,"gmxCreate/gmxMatrixBlockSize"),
			get_integer(er,0));
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxMatrixBlockSize"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxMatrixBlockSize"),
		n_get_string(e_msg));

}


XL_SEXP *
gb_gmxMatrixDimDivide(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
CREATE_WORK * cw;
MATRIX * mtx;
L_CHAR * divide;
L_CHAR * dim;
char * e_msg;
int er;
	cw = get_env_work(env);
	if ( cw == 0 )
		goto inv_format;
	mtx = cw->mtx;
	if ( cw->mode != MXEM_CREATE )
		return 0;
	dim = get_sf_attribute(sf,l_string(std_cm,"dim"));
	if ( dim == 0 ) {
		e_msg = "dim";
		goto inv_param;
	}
	divide = get_sf_attribute(sf,l_string(std_cm,"value"));
	if ( divide == 0 ) {
		e_msg = "value";
		goto inv_param;
	}
	er = set_matrix_dim_divide(mtx,
		atoi(n_string(std_cm,dim)),
		atoi(n_string(std_cm,divide)));
	if ( er < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUTISFIED_INFO,
			l_string(std_cm,"gmxCreate/gmxMatrixDimDivide"),
			get_integer(er,0));
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxMatrixDimDivide"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxMatrixDimDivide"),
		n_get_string(e_msg));

}


XL_SEXP * 
gb_gmxPriority(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * area;
L_CHAR * pri;
L_CHAR * mode;
int _area;
char* e_msg;
MATRIX_PARAM_WORK * w;
MATRIX_PARAM * p;
CREATE_WORK * cw;
	w = get_env_work(env);
	if ( w == 0 )
		goto inv_format;
	p = &w->p;
	cw = w->cw;
	area = get_sf_attribute(sf,l_string(std_cm,"area"));
	if ( area == 0 ) {
		e_msg = "area";
		goto inv_param;
	}
	_area = atoi(n_string(std_cm,area));
	if ( _area < 0 || _area >= MI_MAX ) {
		e_msg = "area boudary error";
		goto inv_param;
	}
	pri = get_sf_attribute(sf,l_string(std_cm,"pri"));
	if ( pri == 0 ) {
		e_msg = "pri";
		goto inv_param;
	}
	mode = get_sf_attribute(sf,l_string(std_cm,"mode"));
	if ( mode == 0 || (l_strcmp(mode,l_string(std_cm,"active")) == 0) )
		p->pri_area[_area] = atoi(n_string(std_cm,pri));
	else if ( l_strcmp(mode,l_string(std_cm,"direct")) == 0 ) {
		cw->pri[MI_MODE_DIRECT][_area] = atoi(n_string(std_cm,pri));
		cw->pri_active[MI_MODE_DIRECT] = 1;
	}
	else if ( l_strcmp(mode,l_string(std_cm,"client")) == 0 ) {
		cw->pri[MI_MODE_CLIENT][_area] = atoi(n_string(std_cm,pri));
		cw->pri_active[MI_MODE_CLIENT] = 1;
	}
	else if ( l_strcmp(mode,l_string(std_cm,"server")) == 0 ) {
		cw->pri[MI_MODE_SERVER][_area] = atoi(n_string(std_cm,pri));
		cw->pri_active[MI_MODE_SERVER] = 1;
	}
	else {
		e_msg = "mode value";
		goto inv_param;
	}
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxMatrixParam/gmxPriority"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxMatrixParam/gmxPriority"),
		n_get_string(e_msg));

}


XL_SEXP *
gb_gmxMatrixParam(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MATRIX_PARAM_WORK pw;
MATRIX * mtx;
L_CHAR * channel_nos;
L_CHAR * dim;
char * e_msg;
XL_SEXP * ret;
int er;
L_CHAR * flags;
CREATE_WORK * cw;

	cw = get_env_work(env);
	if ( cw == 0 )
		goto inv_format;
	mtx = cw->mtx;
ss_printf("CW %p %i\n",cw,cw->mode);
	if ( cw->mode != MXEM_CREATE )
		return 0;
	
	memset(&pw,0,sizeof(pw));
	pw.cw = cw;
	
	channel_nos = get_sf_attribute(sf,l_string(std_cm,"channel_nos"));
	if ( channel_nos == 0 ) {
		e_msg = "channel_nos is required";
		goto inv_param;
	}
	pw.p.channel_nos = atoi(n_string(std_cm,channel_nos));
	if ( pw.p.channel_nos <= 0 ) {
		e_msg = "invalid channel_nos value";
		goto inv_param;
	}
	dim = get_sf_attribute(sf,l_string(std_cm,"dim"));
	if ( dim == 0 ) {
		e_msg = "dim is required";
		goto inv_param;
	}
	pw.p.dim = atoi(n_string(std_cm,dim));
	if ( pw.p.dim <= 0 ) {
		e_msg = "invalid dim value";
		goto inv_param;
	}
	flags = get_sf_attribute(sf,l_string(std_cm,"index_hem"));
	if ( flags && (l_strcmp(flags,l_string(std_cm,"on")) == 0) )
		pw.p.flags |= MPF_INDEX_HEM;
	flags = get_sf_attribute(sf,l_string(std_cm,"cache_file"));
	if ( flags && (l_strcmp(flags,l_string(std_cm,"on")) == 0 ) )
		pw.p.flags |= MPF_CACHE_FILE;
	
	env = new_env(new_env_pair(env,a));
	set_env_work(env,&pw);
	for ( s = cdr(s) ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		ret = eval(env,car(s));
		if ( get_type(ret) == XLT_ERROR )
			return ret;
	}
	er = set_matrix_param(mtx,&pw.p);
	if ( er < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUTISFIED_INFO,
			l_string(std_cm,"gmxCreate/gmxMatrixParam"),
			get_integer(er,0));
	return 0;
inv_format:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"gmxCreate/gmxMatrixParam"),
		n_get_string(e_msg));
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate/gmxMatrixParam"),
		n_get_string(e_msg));

}



XL_SEXP *
gb_gmxCreate_matrix(CREATE_PARAM * cp,XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * filename,*neturl,*key;
MATRIX_PARAM p;
XLISP_ENV * e;
MATRIX * m;
int err,err_org;
XL_SEXP * ret;
CREATE_WORK cw;
int er;
int i;
L_CHAR * currentPhase_mode;
XL_SEXP * current_phase[MI_MAX];

	cp->m = 0;
	cp->mode = 0;
	
	memset(&cw,0,sizeof(cw));

	filename = get_sf_attribute(sf,l_string(std_cm,"filename"));
/*
	if ( filename == 0 )
		goto inv_param;
*/
	neturl = get_sf_attribute(sf,l_string(std_cm,"neturl"));
	key = get_sf_attribute(sf,l_string(std_cm,"key"));
	currentPhase_mode = get_sf_attribute(sf,l_string(std_cm,"currentPhase_mode"));
	m = open_matrix(
		neturl,				// open URL name
		filename,			// save filename
		key,				// KEY name for searching
		0,
		0);

	if ( m == 0 )
		goto open_err;

	err_org = load_matrix_header(m,O_CREAT|O_RDWR,0644);
	if ( err_org == 0 )
		cw.mode = MXEM_EXIST;
	else	cw.mode = MXEM_CREATE;

	p = cp->p;
	
/*
	memset(&p,0,sizeof(p));
	p.write_file = matrix_standard_write_file;
	p.read_file = matrix_standard_read_file;
	p.close_file = close_matrix_file;
*/
	err = set_matrix_param(m,&p);
	if ( err < 0 )
		er_panic("gb_gmxCreate");
	e = new_env(new_env_pair(env,a));
	set_env(e,l_string(std_cm,"____gc_bind"),0);
	cw.mtx = m;
	set_env_work(e,&cw);
	for ( s = cdr(s) ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		ret = eval(e,car(s));
		if ( get_type(ret) == XLT_ERROR )
			goto err1;
	}
	if ( err_org == ME_DESTROY_FILE )
		save_matrix_header(m);

	if  ( cw.pri_active[MI_MODE_DIRECT] ) {
		if ( (er=save_mode_cal(m,MI_MODE_DIRECT,0,cw.pri[MI_MODE_DIRECT])) < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/gmxMatrixParam/gmxPriority"),
				List(n_get_string("mode pri direct"),get_integer(er,0),-1));
	}
	if  ( cw.pri_active[MI_MODE_SERVER] ) {
		if ( (er=save_mode_cal(m,MI_MODE_SERVER,0,cw.pri[MI_MODE_SERVER])) < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/gmxMatrixParam/gmxPriority"),
				List(n_get_string("mode pri server"),get_integer(er,0),-1));
	}
	if  ( cw.pri_active[MI_MODE_CLIENT] ) {
		if ( (er=save_mode_cal(m,MI_MODE_CLIENT,0,cw.pri[MI_MODE_CLIENT])) < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/gmxMatrixParam/gmxPriority"),
				List(n_get_string("mode pri client"),get_integer(er,0),-1));
	}

	if ( cw.phase_active[MI_MODE_DIRECT] ) {
		if ( (er=save_mode_cal_sexp(m,MI_MODE_DIRECT,cw.phase[MI_MODE_DIRECT])) < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/gmxPhase"),
				List(n_get_string("mode phase"),get_integer(er,0),-1));
	}

	if ( cw.phase_active[MI_MODE_SERVER] ) {
		if ( (er=save_mode_cal_sexp(m,MI_MODE_SERVER,cw.phase[MI_MODE_SERVER])) < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/gmxPhase"),
				List(n_get_string("mode phase"),get_integer(er,0),-1));
	}
	if ( cw.phase_active[MI_MODE_CLIENT] ) {
		if ( (er=save_mode_cal_sexp(m,MI_MODE_CLIENT,cw.phase[MI_MODE_CLIENT])) < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/gmxPhase"),
				List(n_get_string("mode phase"),get_integer(er,0),-1));
	}
	
	if ( currentPhase_mode == 0 )
		goto next;
	memset(&p,0,sizeof(p));
	if ( l_strcmp(currentPhase_mode,l_string(std_cm,"direct")) == 0 )
		er=load_mode_cal(current_phase,p.pri_area,m,MI_MODE_DIRECT);
	else if ( l_strcmp(currentPhase_mode,l_string(std_cm,"server")) == 0 )
		er=load_mode_cal(current_phase,p.pri_area,m,MI_MODE_SERVER);
	else if ( l_strcmp(currentPhase_mode,l_string(std_cm,"client")) == 0 )
		er=load_mode_cal(current_phase,p.pri_area,m,MI_MODE_CLIENT);
	else	goto inv_param;
	er = set_matrix_param(m,&p);
	if ( er < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUTISFIED_INFO,
			l_string(std_cm,"gmxCreate/set matrix_param"),
			get_integer(er,0));
	for ( i = 0 ; i < MI_MAX ; i ++ ) {
		er = set_matrix_cal(m,i,current_phase[i]);
		if ( er < 0 )
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNSUTISFIED_INFO,
				l_string(std_cm,"gmxCreate/set phase"),
				get_integer(er,0));
	}
next:
	set_matrix_mode(m,MM_STANBY);
	cp->m = m;
	cp->mode = cw.mode;
	return 0;
open_err:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxCreate"),
		0);
	goto err0;
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxCreate"),
		0);
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxCreate"),
		0);
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxCreate"),
		n_get_string("file path"));
*/
err1:
	close_matrix(m);
err0:
	return ret;
}


