/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"mx_format.h"

void
init_gmxCreate(XLISP_ENV * env0,XLISP_ENV * env1)
{
XLISP_ENV * gmxEnv;
	gmxEnv = new_env(0);
	set_env(env1,l_string(std_cm,"gmxCreate"),
		get_func_prim(gb_gmxCreate,FO_NORMAL,gmxEnv,1,-1));
	init_gmx_format(gmxEnv);
}

XL_SEXP *
gb_gmxCreate(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MX_ENTRY * mx_e;
XL_SEXP * ret;
CREATE_PARAM cp;
L_CHAR * readphase;
L_CHAR * neturl;
L_CHAR * filename;
L_CHAR * key;
	readphase = get_sf_attribute(sf,l_string(std_cm,"readphase"));
	if ( readphase ) {
		neturl = get_sf_attribute(sf,l_string(std_cm,"neturl"));
		filename = get_sf_attribute(sf,l_string(std_cm,"filename"));
		key = get_sf_attribute(sf,l_string(std_cm,"key"));
		mx_e = open_mxread(neturl,filename,key,atoi(n_string(std_cm,readphase)));
		if ( mx_e == 0 )
			goto open_err;
	}
	else {
		memset(&cp,0,sizeof(cp));
		cp.p.write_file = matrix_standard_write_file;
		cp.p.read_file = matrix_standard_read_file;
		cp.p.close_file = close_matrix_file;

		ret = gb_gmxCreate_matrix(&cp,env,s,a,sf);
		if ( get_type(ret) == XLT_ERROR )
			return ret;

		if ( cp.m == 0 )
			goto open_err;

		mx_e = d_alloc(sizeof(*mx_e));
		memset(mx_e,0,sizeof(*mx_e));
		mx_e->c.m = cp.m;
		mx_e->mode = cp.mode;
		new_mx_entry(mx_e,0);
	}

	return get_integer(mx_e->id,0);
open_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxCreate"),
		0);
}

