/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"



XL_SEXP * gb_gmxGetPoint_n();
XL_SEXP * gb_gmxGetPoint_s();

void
init_gmxGetPoint(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env0,l_string(std_cm,"gmxGetPoint"),
		get_func_prim(gb_gmxGetPoint_n,FO_APPLICATIVE,0,3,3));
	set_env(env1,l_string(std_cm,"gmxGetPoint"),
		get_func_prim(gb_gmxGetPoint_s,FO_APPLICATIVE,0,3,3));
}


XL_SEXP *
read_node_channel(MX_ENTRY* e,XL_SEXP * inp,int _ch)
{
MATRIX * m;
MATRIX_NODE * n;
int err;
char * err_msg;
INTEGER64 * dim_code;
XL_SEXP * ret,* info;
XL_SEXP * d_ret;
RECORD_LIST64 * rl;
MATRIX_DATA_TYPE * tp;
int size;
	m = e->c.m;
	set_matrix_env(m,"create-node","disable");

retry:
	dim_code = get_dim_code_from_sexp(m,inp);
	err = 0;
	n = get_matrix_node(&err,m,dim_code,GN_ERROR_NORETRY,0,0);
	info = List(
		get_integer(err,0),
		get_sexp_from_dim_code(m,dim_code),
		-1);
	if ( n == 0 ) {
		d_f_ree(dim_code);
		err_msg = "others";
		goto no_obj;
	}
	if ( err != 0 ) {
		unlock_node(n,0);
		d_f_ree(dim_code);
		if ( err == ME_MATRIX_ERR )
			goto matrix_err;
		sleep_sec(1);
		goto retry;
	}

	gc_push(0,0,"");
	if ( _ch < 0 || _ch >= m->p.channel_nos ) {
		unlock_node(n,0);
		d_f_ree(dim_code);
		gc_pop(0,0);
		goto inv_param;
	}
	if ( n->channel == 0 ) {
		unlock_node(n,0);
		d_f_ree(dim_code);
		err_msg = "others(2)";
		gc_pop(0,0);
		goto no_obj;
	}
	gc_push(0,0,"");
	rl = new_recordlist64(0,0);
	tp = m->channel_info[_ch].data_type;
	if ( tp == 0 ) {
		unlock_node(n,0);
		d_f_ree(dim_code);
		err_msg = "channel not exist";
		gc_pop(0,0);
		gc_pop(0,0);
		goto no_obj;
	}
	if ( n->channel[_ch].data == 0 ) {
		unlock_node(n,0);
		d_f_ree(dim_code);
		err_msg = "channel data not exist";
		gc_pop(0,0);
		gc_pop(0,0);
		goto no_obj;
	}
	(*tp->convert_to_net)(tp,rl,n->channel[_ch].data);
	size = setup_recordlist64(rl);

	d_ret = get_raw(rl->data,size);
	free_recordlist64(rl);
	
	unlock_node(n,0);
	ret = List(n_get_symbol("data"),
			get_sexp_from_dim_code(m,dim_code),
			d_ret,
			-1);
	gc_pop(ret,gc_gb_sexp);
	d_f_ree(dim_code);
	gc_pop(ret,gc_gb_sexp);
	return ret;
inv_param:
	return get_error(
		inp->h.file,
		inp->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxCH"),
		n_get_string("invalid parameter in mxCH"));
no_obj:
	return get_error(
		inp->h.file,
		inp->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxCH"),
		List(n_get_string("invalid object in channel of NODE"),
			n_get_string(err_msg),
			info,-1));
matrix_err:
	return get_error(
		inp->h.file,
		inp->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxCH"),
		n_get_string("invalid matrix loading"));
}

XL_SEXP *
read_1point_normal(MX_ENTRY * e,XL_SEXP * inp)
{
int len;
int i;
MX_CACHE_PARAM p;
XL_SEXP * v;
INTEGER64 * target;
int * ofs;
XL_SEXP * ret,* _ret;
	len = list_length(inp);
	if ( len < 0 )
		return list_error(inp);
	p = e->p;
	p.data_ptrs[0] = mxc_alloc(&e->c,sizeof(char)*e->c.m->p.channel_nos);
	p.data_ptrs[1] = mxc_alloc(&e->c,sizeof(short)*e->c.m->p.channel_nos);
	p.data_ptrs[2] = mxc_alloc(&e->c,sizeof(int)*e->c.m->p.channel_nos);
	p.data_ptrs[3] = mxc_alloc(&e->c,sizeof(INTEGER64)*e->c.m->p.channel_nos);

	if ( len == 2* e->c.m->p.dim + 1 ) {
		target = mxc_alloc(&e->c,sizeof(L_CHAR)*(e->c.m->p.dim+1));
		ofs = mxc_alloc(&e->c,sizeof(int)*e->c.m->p.dim);
		for ( i = 0 ; i < e->c.m->p.dim+1 ; i ++ , inp = cdr(inp) ) {
			v = car(inp);
			if ( get_type(v) != XLT_INTEGER )
				goto inv_param;
			target[i] = v->integer.data;
		}
		for ( ; i < 2 * e->c.m->p.dim + 1 ; i ++ , inp = cdr(inp) ) {
			v = car(inp);
			if ( get_type(v) != XLT_INTEGER )
				goto inv_param;
			ofs[i-e->c.m->p.dim-1] = v->integer.data;
		}
	}
	else if ( len == e->c.m->p.dim + 1 ) {
		target = mxc_alloc(&e->c,sizeof(L_CHAR)*(e->c.m->p.dim+1));
		ofs = 0;
		for ( i = 0 ; i < e->c.m->p.dim+1 ; i ++ , inp = cdr(inp) ) {
			v = car(inp);
			if ( get_type(v) != XLT_INTEGER )
				goto inv_param;
			target[i] = v->integer.data;
		}
	}
	else	goto inv_param;
	p.dc = target;
	p.ofs = ofs;
	if ( read_mx_cache(&p) < 0 )
		goto no_object;

	ret = 0;
	for ( i = 0 ; i < e->c.ds_len ; i ++ ) {
		if ( p.data_ix[i].x == MXC_INVALID )
			continue;
		switch ( e->c.m->channel_info[e->c.access_ch[i]].data_type->type & MDT_BASE_TYPE ) {
		case MDT_BIT:
		case MDT_INT8:
		case MDT_UINT8:
			_ret = get_integer(((char*)p.data_ptrs[p.data_ix[i].p])
					[p.data_ix[i].x],
					0);
			break;
		case MDT_INT16:
		case MDT_UINT16:
			_ret = get_integer(((short*)p.data_ptrs[p.data_ix[i].p])
					[p.data_ix[i].x],
					0);
			break;
		case MDT_INT32:
		case MDT_UINT32:
			_ret = get_integer(((int*)p.data_ptrs[p.data_ix[i].p])
					[p.data_ix[i].x],
					0);
			break;
		case MDT_INT64:
		case MDT_UINT64:
		case MDT_RGB8:
			_ret = get_integer(((INTEGER64*)p.data_ptrs[p.data_ix[i].p])
					[p.data_ix[i].x],
					0);
			break;
		case MDT_DOUBLE:
			_ret = get_floating(((double*)p.data_ptrs[p.data_ix[i].p])
					[p.data_ix[i].x],
					0);
			break;
		case MDT_FLOAT:
			_ret = get_floating(((float*)p.data_ptrs[p.data_ix[i].p])
					[p.data_ix[i].x],
					0);
			break;
		default:
			_ret = 0;
			break;
		}
		ret = cons(List(
			get_integer(e->c.access_ch[i],0),
			_ret,
			-1),
			ret);
	}
	ret = reverse(ret);
	goto end;
inv_param:
	ret = get_error(
		inp->h.file,
		inp->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxGetPoint"),
		n_get_string("param"));
	goto end;
no_object:
	ret = get_error(
		inp->h.file,
		inp->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"gmxGetPoint"),
		n_get_string("object"));
	goto end;
end:
	mxc_free(&e->c,p.data_ptrs[0]);
	mxc_free(&e->c,p.data_ptrs[1]);
	mxc_free(&e->c,p.data_ptrs[2]);
	mxc_free(&e->c,p.data_ptrs[3]);
	mxc_free(&e->c,target);
	if ( ofs )
		mxc_free(&e->c,ofs);
	return ret;
}


XL_SEXP *
read_1point(MX_ENTRY * e,XL_SEXP * inp,XL_SYM_FIELD * sf)
{
L_CHAR * mode;
int ch;
L_CHAR * _ch;
	mode = get_sf_attribute(sf,l_string(std_cm,"mode"));
	if ( mode == 0 )
		goto normal;
	if ( l_strcmp(mode,l_string(std_cm,"normal")) == 0 ) {
	normal:
		return read_1point_normal(e,inp);
	}
	else if ( l_strcmp(mode,l_string(std_cm,"block")) == 0 ) {
		_ch = get_sf_attribute(sf,l_string(std_cm,"channel"));
		if ( _ch == 0 )
			return get_error(
				inp->h.file,
				inp->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"gmxGetPoint"),
				n_get_string("attribute channel is required"));
		ch = atoi(n_string(std_cm,_ch));
		return read_node_channel(e,inp,ch);
	}
	else {
		return get_error(
			inp->h.file,
			inp->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"gmxGetPoint"),
			n_get_string("attribute::mode"));
	}
}

XL_SEXP *
read_point(MX_ENTRY * e,XL_SEXP * inp,XL_SYM_FIELD * sf)
{
XL_SEXP * ret,* _ret;
	if ( get_type(inp) != XLT_PAIR )
		goto inv_param;
	switch ( get_type(car(inp)) ) {
	case XLT_PAIR:
		/* two or more point */
		ret = 0;
		for ( ; get_type(inp) == XLT_PAIR ; inp = cdr(inp) ) {
			_ret = read_1point(e,car(inp),sf);
			if ( get_type(_ret) == XLT_ERROR ) {
				ret = _ret;
				break;
			}
			ret = cons(_ret,ret);
		}
		if ( get_type(ret) != XLT_ERROR )
			ret = reverse(ret);
		break;
	case XLT_INTEGER:
	case XLT_FLOAT:
		/* 1 point */
		ret = read_1point(e,inp,sf);
		break;
	default:
		goto inv_param;
	}
	return ret;
inv_param:
	return get_error(
		inp->h.file,
		inp->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxGetPoint"),
		List(n_get_string("read_point"),
			inp,-1));
}





XL_SEXP *
open_mxread_related(L_CHAR * file,XL_SEXP * s,XL_SEXP * pdata,XL_SYM_FIELD * sf)
{
L_CHAR * fn;
L_CHAR * target[2];
MX_ENTRY * e;
XL_SEXP * ret;
XL_GETFILE * gf;
int i;

	ret = 0;

	fn = nl_copy_str(std_cm,"Get");
	target[0] = target[1] = 0;
	ret = get_path(target,&gf,file,s,fn);
	if ( get_type(ret) == XLT_ERROR )
		goto end;
	d_f_ree(fn);
	if ( l_strcmp(gf->mode,l_string(std_cm,"lod")) ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNSUPPORT_MODE,
			l_string(std_cm,"Get"),
			n_get_string("unsupport Get mode"));
	}

	for ( i = 0 ; i < 2 ; i ++ ) {
		if ( target[i] == 0 )
			break;

		e = open_mxread(0,target[i],0,MI_MODE_SERVER);
		if ( e == 0 )
			continue;
		ret = read_point(e,pdata,sf);
		goto end;
	}
	if ( i == 2 ) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_OPEN_FILE,
			l_string(std_cm,"gmxGetPoint"),
			0);
	}
end:
	if ( target[0] )
		d_f_ree(target[0]);
	if ( target[1] )
		d_f_ree(target[1]);
	return ret;
}


XL_SEXP *
gb_gmxGetPoint(int s_flag,XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * path_type;
MX_ENTRY * e;
XL_SEXP * filename;
XL_SEXP * ret;
XL_SEXP * pdata;
	path_type = get_sf_attribute(sf,l_string(std_cm,"path-type"));
	if ( s_flag == 0 ) {
		if ( path_type == 0 )
			goto permission_error;
		if ( l_strcmp(path_type,l_string(std_cm,"absolute")) == 0 )
			goto permission_error;
	}
	filename = get_el(s,1);
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	pdata = get_el(s,2);
	if ( get_type(pdata) != XLT_PAIR )
		goto type_missmatch;
	if ( path_type == 0 )
		goto abs_path;
	if ( l_strcmp(path_type,l_string(std_cm,"absolute")) == 0 ) {
	abs_path:
		e = open_mxread(0,filename->string.data,0,MI_MODE_DIRECT);
		if ( e == 0 )
			goto open_err;
		ret = read_point(e,pdata,sf);
	}
	else if ( l_strcmp(path_type,l_string(std_cm,"related")) == 0 ) {
		ret = open_mxread_related(filename->string.data,s,pdata,sf);
	}
	else if ( l_strcmp(path_type,l_string(std_cm,"network")) == 0 ) {
		e = open_mxread(filename->string.data,0,0,MI_MODE_SERVER);
		if ( e == 0 )
			goto open_err;
		ret = read_point(e,pdata,sf);
	}
	else if ( l_strcmp(path_type,l_string(std_cm,"key")) == 0 ) {
		e = open_mxread(0,0,filename->string.data,MI_MODE_DIRECT);
		if ( e == 0 )
			goto open_err;
		ret = read_point(e,pdata,sf);
	}
	else	goto inv_param;
	return ret;
open_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxGetPoint"),
		0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxGetPoint"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxGetPoint"),
		n_get_string("attribute:path-type"));
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxGetPoint"),
		n_get_string("file path"));
}

XL_SEXP *
gb_gmxGetPoint_n(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
	return gb_gmxGetPoint(0,env,s,a,sf);
}



XL_SEXP *
gb_gmxGetPoint_s(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
	return gb_gmxGetPoint(1,env,s,a,sf);
}



