/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"ppm_types.h"

void
matrix_test(MATRIX * m);
extern int test_debug;



XL_SEXP * gb_gmxScan();

void
init_gmxScan(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxScan"),
		get_func_prim(gb_gmxScan,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
gb_gmxScan(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * id;
L_CHAR * dir;
L_CHAR * area;
int _dir;
int _area;
char * e_msg;
INTEGER64 * _start,* _end;
MX_ENTRY * mx_e;
int ret;
	e_msg = "id";
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 )
		goto inv_param;
	e_msg = "value of id";
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 )
		goto inv_param;

	e_msg = "value of call-dir";
	dir = get_sf_attribute(sf,l_string(std_cm,"call-dir"));
	if ( dir == 0 )
		_dir = 0;
	else if ( l_strcmp(dir,l_string(std_cm,"pre")) == 0 )
		_dir = 0;
	else if ( l_strcmp(dir,l_string(std_cm,"post")) == 0 )
		_dir = 1;
	else	goto inv_param;

	e_msg = "area";
	area = get_sf_attribute(sf,l_string(std_cm,"area"));
	if ( area == 0 )
		goto inv_param;
	e_msg = "area boundary";
	_area = atoi(n_string(std_cm,area));
	if ( _area < 0 || _area >= MI_MAX )
		goto inv_param;

	_start = get_dim_code_from_sexp(mx_e->c.m,get_el(s,1));
	_end = get_dim_code_from_sexp(mx_e->c.m,get_el(s,2));
	e_msg = "dim_code format (start)";
	if ( _start == 0 )
		goto inv_param;
	e_msg = "dim_code format (end)";
	if ( _end == 0 )
		goto inv_param;
	ret = matrix_scan(mx_e->c.m,_dir,_area,_start,_end,0,0);
	d_f_ree(_start);
	d_f_ree(_end);

	return get_integer(ret,0);

/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxScan"),
		0);
cannot_open:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxScan"),
		List(n_get_string("cannot open the file"),
			filename,
			-1));
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxScan"),
		List(n_get_string("invalida parameter (attribute id)"),
			n_get_string(e_msg),
			-1));
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxScan"),
		n_get_string("file path"));
*/
}

