/**********************************************************************
 
	Copyright (C) 2003-
	Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___ENCODING_TABLES_H___
#define ___ENCODING_TABLES_H___

#include	"lc_encode.h"

#ifndef __SCRIPT__
enum {
  smRoman                       = 0,
  smJapanese                    = 1,
  smTradChinese                 = 2,    /* Traditional Chinese*/
  smKorean                      = 3,
  smArabic                      = 4,
  smHebrew                      = 5,
  smGreek                       = 6,
  smCyrillic                    = 7,
  smRSymbol                     = 8,    /* Right-left symbol*/
  smDevanagari                  = 9,
  smGurmukhi                    = 10,
  smGujarati                    = 11,
  smOriya                       = 12,
  smBengali                     = 13,
  smTamil                       = 14,
  smTelugu                      = 15,
  smKannada                     = 16,   /* Kannada/Kanarese*/
  smMalayalam                   = 17,
  smSinhalese                   = 18,
  smBurmese                     = 19,
  smKhmer                       = 20,   /* Khmer/Cambodian*/
  smThai                        = 21,
  smLao                         = 22,
  smGeorgian                    = 23,
  smArmenian                    = 24,
  smSimpChinese                 = 25,   /* Simplified Chinese*/
  smTibetan                     = 26,
  smMongolian                   = 27,
  smEthiopic                    = 28,
  smGeez                        = 28,   /* Synonym for smEthiopic*/
  smCentralEuroRoman            = 29,   /* For Czech, Slovak, Polish, Hungarian, Baltic langs*/
  smVietnamese                  = 30,
  smExtArabic                   = 31,   /* extended Arabic*/
  smUninterp                    = 32    /* uninterpreted symbols, e.g. palette symbols*/
};

/* Extended script code for full Unicode input*/
enum {
  smUnicodeScript               = 0x7E
};
#endif


typedef struct code_script_table {
	int			script;
	L_CHAR			lcz[2];
	L_CHAR			mask[2];
	L_CHAR			from;
	L_CHAR			to;
} CODE_SCRIPT_TABLE;

typedef struct name_script_table {
	char *			script;
	L_CHAR			lcz[2];
	L_CHAR			mask[2];
	L_CHAR			from;
	L_CHAR			to;
} NAME_SCRIPT_TABLE;


extern CODE_SCRIPT_TABLE mac_script_tbl[];
extern NAME_SCRIPT_TABLE bdf_encoding_table[];
extern CODE_SCRIPT_TABLE ft2_encoding_table[];


#endif


