/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___R64_H___
#define ___R64_H___

#include "complex.h"
#include "r64_types.h"

/* errors */

#define E_OK	0
#define E_SYS	(-1) 	/* system error see errno */
#define E_FATAL	(-2)	/* fatel error on r64 system */
#define E_NOMEM	(-3)	/* no memory */
#define E_DFILE	(-4)	/* distroyed file */
#define E_INVFILE (-5)	 /* invalid file type */
#define E_WRITE (-6)	/* connot write */
#define E_OVER	(-7)	/* over point and so on */
#define E_PAR	(-8)	/* parameter error */
#define E_NOLEV (-9)	/* no exist level */

/* read color method type */

#define RC_BACK		0
#define RC_NEAR		1

/* control command */
#define R64_SET_RCTYPE			0
#define R64_SET_BACKGROUND_COLOR	1

R64_FILE * r64_open_file(
	char * filename,
	int ctl,
	int mode,
	char filetype,
	int width,
	int height);
int r64_close_file(R64_FILE * f);
int r64_check_level(R64_FILE * f,int level);
int r64_ctl(R64_FILE * f,int cmd,...);
int r64_set(
	R64_FILE * f,
	int w,
	int h,
	int level,
	unsigned char * buf);
int r64_red(
	unsigned char * buf,
	R64_FILE * f,
	int w,
	int h,
	int level);
int r64_plane(
	char **	data,
	int *	w,
	int *	h,
	int *	size,
	R64_FILE * f,
	int x,
	int y,
	int level);
int r64_flush(R64_FILE * f);
int r64_new_level(R64_FILE * f,int level);
void r64_init();

CR_FILE * cr_open_file(
	char * filename,
	int ctl,
	int mode,
	int rect_size,
	int width,
	int height);
int cr_close_file(CR_FILE * f);
unsigned int get_tbl_ofs(CR_FILE * f,int w,int h,int level);
int cr_read(CR_MEM_TBL * b,CR_FILE * f,int width,int height,int level);
void cr_free_cr_mem_tbl(CR_MEM_TBL *);
unsigned char cr_cal(int,char);
int cr_inv_cal(int,char);
int cr_write_file(char * filename,int mode,int rect_size,R64_FILE * r64);

int get_cr_tbl_nos(CR_FILE * f);
void delete_cr_ring(CR_ENT * e);
void insert_cr_ring(CR_FILE * f,CR_ENT * e);
void touch_cr_ent(CR_FILE * f,CR_ENT * e);
CR_ENT * new_cr_ent(CR_FILE * f);
void free_cr_ent(CR_FILE * f,CR_ENT * e);
void free_cr_mem_tbl(CR_MEM_TBL * t);
void r64_init();
void save_test(double * buf[3],int size);
double window_fn(int x,int y);
void flush_buf(
	R64_FILE * f,
	int i,
	double * buf[3],
	int level,
	int dest_w,
	int buf_line);
int r64_new_level_hifi(R64_FILE * f,int level);
void write_out(R64_FILE * f,int level,int x,int y);
int r64_new_level_lofi(R64_FILE * f,int level);
int cr_check_level(CR_FILE * f,int level);
void r64_init();

#endif
