/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_GROUP_BOX_H___
#define ___V_GROUP_BOX_H___

#include "v/VObject.h"


class VGroupBox : public VObject
{
  public:
	enum { object_type = VO_GBOX };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return 1; }
	
	enum VGroupBoxAttr {
		primary		= 0x0,
		secondary	= 0x1
	};

	static VGroupBox*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VGroupBox*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VGroupBox*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
	
  protected:
	virtual ~VGroupBox();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	virtual VExError add_child_do(VObject* child);
	virtual void	remove_child_do(VObject* child);

  private:
	static VObject *internal_new(){
		return new VGroupBox();
	}

	VSize	label_size;
};

#endif
