/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TAB_VIEW_H___
#define ___V_TAB_VIEW_H___

#include "v/VAlignView.h"

typedef class VVAlignView VTabPage;

class VTabView : public VObject
{
      public:
	enum { object_type = VO_TABV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return MAX_CHILDREN_NO_LIMIT; }

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	struct tab_set {
		int pages;
		const L_CHAR **names;
	};
	static VTabView*	create(
							const VObjectStatus *s,
							int flags,
							int pages,
							const L_CHAR **names,
							VExError *err=0) {
		tab_set arg = {pages, names};
		return create(s, flags, &arg, err);
	}
	static VTabView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VTabView*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}

	// get specified page (0..pages-1)
	virtual VTabPage*	get_page(int n);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	virtual void	value_changed();

protected:
	virtual ~VTabView();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

	virtual VExError add_child_do(VObject*);
	virtual void	remove_child_do(VObject* child);

	virtual VError	accept_child_ex(long type, VObject* obj) const {
		return (creating && type == VTabPage::object_type) ? V_ER_NO_ERR : V_ER_PARAM;
	}
	
	int		creating;
	int		n_pages;
	VTabPage	**pages;
	short	min_width;

  private:
	static VObject *internal_new(){
		return new VTabView();
	}
};

#endif
