/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_GB_WPMENU_EDIT_H___
#define ___V_GB_WPMENU_EDIT_H___


extern "C" {
#include	"gbgraph.h"
}


#include	"v/VgbFlame.h"
#include	"v/VgbQueryIndicate.h"
#include	"v/VSplitView.h"
#include	"v/VxlEditLine.h"

#define VMT_WARP_EDIT_NEW_GROUP			VMT_CONV(-10201)
#define VMT_WARP_EDIT_NEW_GROUP_STR		VMT_STR(-10201)

typedef struct _VgbWPMenuEditStatus {
	WARP_POINT_MENU *		menu;
	L_CHAR *			new_button_descriptor;
	L_CHAR *			del_button_descriptor;
	L_CHAR *			edit_button_descriptor;
	L_CHAR *			untitled;
	L_CHAR *			details;
	L_CHAR *			close;
	L_CHAR *			wp_configure;

	L_CHAR *			info_item;
	L_CHAR *			info_content;
	L_CHAR *			info_menu_title;
	L_CHAR *			info_menu_link;
	L_CHAR *			info_type;
	L_CHAR *			info_title;
	L_CHAR *			info_tracking;
	L_CHAR *			info_resolution;
	L_CHAR *			info_rotate;
	L_CHAR *			info_center_x;
	L_CHAR *			info_center_y;
	L_CHAR *			info_base;
	L_CHAR *			info_lock_base;

	L_CHAR *			info_layer_entry;
	L_CHAR *			info_layer_flags;
	
	L_CHAR *			load_menu_link;
	L_CHAR *			unload_menu_link;
	L_CHAR *			open_in_ind_window;

	L_CHAR *			loading_target;
	L_CHAR *			open_func;
	VImage *			wp_img;
	VImage *			wpgroup_img;

} VgbWPMenuEditStatus;

#define VSF_GB_WPE_MENU			(1<<0)
#define VSF_GB_WPE_NEW_BUTTON_DESC	(1<<1)
#define VSF_GB_WPE_DEL_BUTTON_DESC	(1<<2)
#define VSF_GB_WPE_EDIT_BUTTON_DESC	(1<<3)

#define VSF_GB_WPE_UNTITLED		(1<<4)
#define VSF_GB_WPE_DETAILS		(1<<5)
#define VSF_GB_WPE_CLOSE		(1<<6)
#define VSF_GB_WPE_WP_CONFIGURE		(1<<7)
#define VSF_GB_WPE_LOADING_TARGET	(1<<8)
#define VSF_GB_WPE_WP_IMG		(1<<9)
#define VSF_GB_WPE_WPGROUP_IMG		(1<<10)

#define VSF_GB_WPE_INFO_ITEM		(1<<11)
#define VSF_GB_WPE_INFO_CONTENT		(1<<12)
#define VSF_GB_WPE_INFO_MENU_TITLE	(1<<13)
#define VSF_GB_WPE_INFO_MENU_LINK	(1<<14)
#define VSF_GB_WPE_INFO_TYPE		(1<<15)
#define VSF_GB_WPE_INFO_TITLE		(1<<16)
#define VSF_GB_WPE_INFO_TRACKING	(1<<17)
#define VSF_GB_WPE_INFO_RESOLUTION	(1<<18)
#define VSF_GB_WPE_INFO_ROTATE		(1<<19)
#define VSF_GB_WPE_INFO_CENTER_X	(1<<20)
#define VSF_GB_WPE_INFO_CENTER_Y	(1<<21)
#define VSF_GB_WPE_INFO_BASE		(1<<22)
#define VSF_GB_WPE_INFO_LOCK_BASE	(1<<23)
#define VSF_GB_WPE_INFO_LAYER_ENTRY	(1<<24)
#define VSF_GB_WPE_INFO_LAYER_FLAGS	(1<<25)
#define VSF_GB_WPE_LOAD_MENU_LINK	(1<<26)
#define VSF_GB_WPE_UNLOAD_MENU_LINK	(1<<27)
#define VSF_GB_WPE_OPEN_IN_IND_WINDOW	(1<<28)
#define VSF_GB_WPE_OPEN_FUNC		(1<<29)

#define VSF_GB_WPE_ALL			0x3fffffff

#define POS_GB_WPE_INFO_COLS		3
#define POS_GB_WPE_INFO_LAYERS_COLS	2
#define POS_GB_WPE_COLS	(POS_GB_WPE_INFO_COLS < POS_GB_WPE_INFO_LAYERS_COLS ? \
				POS_GB_WPE_INFO_LAYERS_COLS:	\
				POS_GB_WPE_INFO_COLS)

#define POS_GB_WPE_INFO_ITEM		0
#define POS_GB_WPE_INFO_EDITABLE	1
#define POS_GB_WPE_INFO_CONTENT		2

#define POS_GB_WPE_SPACE_1		1
#define POS_GB_WPE_INFO_MENU_TITLE	2
#define POS_GB_WPE_INFO_MENU_LINK	3
#define POS_GB_WPE_SPACE_2		4
#define POS_GB_WPE_INFO_TYPE		5
#define POS_GB_WPE_INFO_TITLE		6
#define POS_GB_WPE_INFO_TRACKING	7
#define POS_GB_WPE_INFO_RESOLUTION	8
#define POS_GB_WPE_INFO_ROTATE		9
#define POS_GB_WPE_INFO_CENTER_X	10
#define POS_GB_WPE_INFO_CENTER_Y	11
#define POS_GB_WPE_INFO_BASE		12
#define POS_GB_WPE_INFO_LOCK_BASE	13


#define POS_GB_WPE_INFO_LAYER_FLAGS	0
#define POS_GB_WPE_INFO_LAYER_ENTRY	1


typedef struct warp_point_menu_ext {
	struct warp_point_menu_ext *	next;
	int				no;
	WARP_POINT_MENU *		wpm;
	struct warp_point_menu_ext *	submenu;
	
	unsigned			selected:1;
	unsigned			header:1;

	VBackColorView *		main_bc;
//	VStaticText *			main_text;
	VxlEditLine *			main_text;
	VxlTreeView *			submenu_xltv_obj;
#define SC_VISIBLE	0
#define SC_LOAD		1
#define SC_OPEN		2
#define SC_MAX		3
	VObject *			submenu_ctl[SC_MAX];
} WARP_POINT_MENU_EXT;

typedef struct _VgbWPMenuEditWork {
	VgbWPMenuEditStatus		sts;
	VgbQueryIndicateStatus		qi_sts;
	VxlTreeViewStatus		xltv_sts;
	int				qi_flags;
	int				xltv_flags;

	VHSplitView *			hsv_obj;
	VxlTreeView *			xltv_obj;

	VPushButton *			details_button;
	VPushButton *			close_button;

	VTreeView *			meta_data_obj;
	VTreeView *			layers_data_obj;
	int				layer_rows;

	VgbQueryIndicate *		qi_obj;

	WARP_POINT_MENU_EXT *		wpm_ext;
	WARP_POINT_MENU_EXT *		edit_wpm;
	WARP_POINT_MENU_EXT *		edit_wpm_detail;
	unsigned			dirty_flag:1;
} VgbWPMenuEditWork;

class VgbWPMenuEdit : public VMacro
{
  public:
	enum { object_type = VO_WPME };

	virtual unsigned	get_type() const { return object_type; }

	static VgbWPMenuEdit*
	create(const VObjectStatus *s, int flags, VExError* err=0) {
		return create(s, flags, 0, err);
	}
	static VgbWPMenuEdit*
	create(const VObjectStatus *s, int flags, void * arg, VExError* err) {
		return static_cast<VgbWPMenuEdit*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_wpmedit_status(
				VgbWPMenuEditStatus *,
				int flags) const;
	virtual VExError set_wpmedit_status(
				const VgbWPMenuEditStatus *,
				int flags);
/*
	virtual VExError get_xltv_status(
				VgbWPMenuEditStatus *,
				int flags) const;
	virtual VExError set_xltv_status(
				const VgbWPMenuEditStatus *,
				int flags);
	virtual VExError get_qind_status(
				VgbWPMenuEditStatus *,
				int flags) const;
	virtual VExError set_qind_status(
				const VgbWPMenuEditStatus *,
				int flags);
*/
	static void copy_wpmedit_status(VgbWPMenuEditStatus *,VgbWPMenuEditStatus *,int*);
	static void free_wpmedit_status(VgbWPMenuEditStatus *);

  protected:

  	virtual ~VgbWPMenuEdit();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual VExError create_do_out_of_lock(
			const VObjectStatus *,int flags,VObject * nmp,void * arg);
	virtual void	destroy_do(VObject*);
	virtual void	destroy_do_out_of_lock(VObject*);
	
	void _loading_target_wpm();
	void _set_wpm_ext_list(WARP_POINT_MENU_EXT ** v,WARP_POINT_MENU * wp,VObjectStatus * s,int flags,
			int header_flag);
	void _free_wpm_ext_list(WARP_POINT_MENU_EXT ** v);
	WARP_POINT_MENU * _copyout_wpm_ext_list(WARP_POINT_MENU_EXT ** v,int from,int to);
	void _copyin_wpm_ext_list(VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,WARP_POINT_MENU * wp,
			int at,int hilite_flag);
	void _delete_wpm_ext_list(VxlTreeView * tv,WARP_POINT_MENU_EXT ** v,int from,int to);
	void _new_wpm_object_1(VxlTreeView * tv,WARP_POINT_MENU_EXT * e,VObjectStatus*,int);
	void _new_wpm_objects(VxlTreeView * tv,WARP_POINT_MENU_EXT * e,VObjectStatus*,int,int);
	static void _min_size_tick(int data);
	static int _xltv_focus_handler(
		int event_type,
		VObject * tv,
		int edit_type,
		int data1,
		VBackColorView  ** data2,
		void * arg);
	int _xltv_focus_handler_obey_edit(
		int event_type,
		VxlTreeView * tv,
		int edit_type,
		int data1,
		VBackColorView  ** data2,
		void * arg);
	WARP_POINT_MENU * _get_selected_wpm(
			VxlTreeView * tv,
			WARP_POINT_MENU_EXT ** v,int type,
			VBackColorView **,int);
	void _insert_after_selected_wpm(VxlTreeView *,WARP_POINT_MENU_EXT ** v,
			VBackColorView **,int,WARP_POINT_MENU * wpm);
	WARP_POINT_MENU_EXT *
	 __insert_after_selected_wpm(
			VxlTreeView ** tv_ret,
			WARP_POINT_MENU_EXT *** v_ret,
			VxlTreeView *,WARP_POINT_MENU_EXT ** v,
			VBackColorView **,int);
	void _wpe_new();
	static V_CALLBACK_D(_wpe_new);
	void _wpe_save_as();
	static V_CALLBACK_D(_wpe_save_as);
	void _wpe_open();
	static V_CALLBACK_D(_wpe_open);
	static V_CALLBACK_D(_wpe_new_group);
	void __wpe_new_group();
	static V_CALLBACK_D(_wpe_save);
	void __wpe_save();
	void _set_dirty_flag();
	void _start_edit_wpm(VBackColorView ** bcl,int len);
	void _finish_edit_wpm(int);
	WARP_POINT_MENU_EXT*_get_wpm_by_bc(WARP_POINT_MENU_EXT **v,VBackColorView * bc);

	void __wpe_details();
	static V_CALLBACK_D(_wpe_details);
	void __wpe_close();
	static V_CALLBACK_D(_wpe_close);

	void _make_value_tree_view(VObjectStatus * s,int flags);
	void _make_tv_node_info(VTreeView * tv,int key,L_CHAR * item,bool editable);
	void _set_tv_node_info(VTreeView * tv,int key,L_CHAR * data1,bool editable);
	void _set_tv_node_layers(VTreeView * tv,int key,int data0,L_CHAR * data1,bool editable);
	void _set_tv_wpm(WARP_POINT_MENU_EXT * e);
	void _set_tv_wpm_event();
	void _check_edit_wpm();
	int _check_edit_wpm_floating(REAL1 * tp,int key);
	int _check_edit_wpm_text(L_CHAR ** tp,int key);
	int _check_edit_wpm_layer(WARP_POINT_LAYER * lr,int key);
	void _new_wpm_object_header(VxlTreeView * tv,WARP_POINT_MENU_EXT * e,
				VObjectStatus * s,int flags,
				int submenu_type,WARP_POINT_MENU_EXT * submenu);
	void _delete_space(L_CHAR * a);

	static V_CALLBACK_D(_unload_button);
	void _unload_button(VObject * obj);
	void _unload_button(VObject * obj,WARP_POINT_MENU_EXT*,WARP_POINT_MENU_EXT*);

	static V_CALLBACK_D(_load_button);
	void _load_button(VObject * obj);
	void _load_button(VObject * obj,WARP_POINT_MENU_EXT*);
	static void _load_button(XL_SEXP * ret,L_CHAR * target,void*user_arg);
	
	typedef struct _load_button_t {
		struct _load_button_t *	next;
		VgbWPMenuEdit *		e_obj;
		VObject *		b_obj;
		WARP_POINT_MENU *	wpm;
		L_CHAR *		target;
		unsigned		end_flag:1;
	} _LOAD_BUTTON_T;
	
	_LOAD_BUTTON_T *	_lb_head,*_lb_tail;
	
	int _load_button(_LOAD_BUTTON_T * tt);
	void _load_button(WARP_POINT_MENU_EXT * e,_LOAD_BUTTON_T *);

	void _wpe_close_handler(VObject * object,void * sys_arg);
	static V_CALLBACK_D(_wpe_close_handler);
	
	void _set_window_title();

private:
	static VObject *internal_new(){
	VgbWPMenuEdit * ret;
		ret = new VgbWPMenuEdit();
		return ret;
	}
	VgbWPMenuEditWork	wpm_w;
	V_CALLBACK(win_close_handler);
	void * win_close_arg;
};




// ==================================================
// CLIPBOARD FOR WARP POINT 



extern VIM VIM_VdataWP;


class VdataWP : public VdataXL
{
  public:

	VdataWP(const L_CHAR *str,int * erp=0,bool valid=1);
	VdataWP(const char *str,int * erp=0,bool valid=1);
	VdataWP(const XL_SEXP * s,int * erp=0,bool valid=1);
	VdataWP(const WARP_POINT * s,int * erp=0,bool valid=1);
	VdataWP(Vdata * d,int * erp=0,bool valid=1);
	virtual ~VdataWP();

	static bool clipboard_available(bool lock_flag=1);
	static VdataWP * new_from_clipboard();

	virtual char * get_VdataString(int * erp=0);
	virtual L_CHAR * get_VdataLString(int * erp=0);
	virtual XL_SEXP * get_VdataXL(int * erp=0);
	virtual WARP_POINT * get_VdataWP(int * erp=0);
  protected:
};



extern VIM VIM_VdataWPM;


class VdataWPM : public VdataWP
{
  public:

	VdataWPM(const L_CHAR *str,int * erp=0,bool valid=1);
	VdataWPM(const char *str,int * erp=0,bool valid=1);
	VdataWPM(const XL_SEXP * s,int * erp=0,bool valid=1);
	VdataWPM(const WARP_POINT * s,int * erp=0,bool valid=1);
	VdataWPM(const WARP_POINT_MENU * s,int * erp=0,bool valid=1);
	VdataWPM(Vdata * d,int * erp=0,bool valid=1);
	virtual ~VdataWPM();

	static bool clipboard_available(bool lock_flag=1);
	static VdataWPM * new_from_clipboard();

	virtual char * get_VdataString(int * erp=0);
	virtual L_CHAR * get_VdataLString(int * erp=0);
	virtual XL_SEXP * get_VdataXL(int * erp=0);
	virtual WARP_POINT * get_VdataWP(int * erp=0);
	virtual WARP_POINT_MENU * get_VdataWPM(int * erp=0);
  protected:
};






void
free_VgbWPMenuEditStatus(VgbWPMenuEditStatus * q_sts);




#endif
