/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___WINDOW_H___
#define ___WINDOW_H___

#include	"long_char.h"
#include	"text_render.h"

typedef struct pic_element {
	struct pic_element *	next;
	LC_STRING_PIC		p;
	unsigned int * 		data;
	unsigned char *		alpha;
	int			line;
	int			flags;
	L_CHAR *		ref;
} PIC_ELEMENT;

typedef struct pic {
	I_RECT		rect;
	PIC_ELEMENT *	list;
} PIC;

typedef struct pic_list {
	unsigned int	color;
	int		flags;
#define PLF_CENTER	0x00000001
#define PLF_ANCOR	0x00000002
	L_CHAR * 	ref;
	int		ceil;
	I_POINT		cursol;
	int		line;
	PIC		pic;
} PIC_LIST;

void
get_string_pic(
	LC_STRING_PIC * p,
	LC_WRITING_STYLE * win,
	L_CHAR * str,
	int	size,
	int 	dir);
void
get_string_pic_font(
	LC_STRING_PIC * sp,
	LC_FONT * font,
	int size,
	L_CHAR * str,
	int len,
	int dir);
void print_str(L_CHAR * s);
void compose_pic(LC_STRING_PIC * p,LC_STRING_PIC * pp);
void pic_rotate_90(LC_STRING_PIC * dest,LC_STRING_PIC * src);

void sp_get_sequence_pic(PIC * pi,TR_SEQUENCE * sq);

int sp_min_line_pixels(TR_BOX_LINE * bl);
void sp_line_dir_metric(TR_SEQUENCE * sq,TR_CHAR_INFO * ci);
void sp_line_height_metric_horizontal(TR_SEQUENCE * sq,TR_CHAR_INFO * ci);
void sp_line_height_metric_vertical(TR_SEQUENCE * sq,TR_CHAR_INFO * ci);
void sp_line_height_metric(TR_SEQUENCE * sq,TR_CHAR_INFO * ci);
TR_ERROR sp_line_height_check(TR_SEQUENCE * sq,TR_CHAR_INFO * ci);
TR_ERROR sp_lang_line_ctl_weight(
	TR_SEQUENCE * sq,
	TR_CHAR_INFO * ci,
	TR_LL_CTL * ctl);
TR_ERROR sp_lang_line_ctl_return_code(
	TR_SEQUENCE * sq,
	TR_CHAR_INFO * ci,
	TR_LL_CTL * ctl);
void sp_get_pic_element(PIC * pi,TR_SEQUENCE * sq,TR_ELEMENT * el,I_POINT p);
void sp_get_pic_box_line(PIC * pi,TR_SEQUENCE * sq,TR_BOX_LINE * bl,I_POINT p);
void sp_get_pic_box(PIC * pi,TR_SEQUENCE * sq,TR_BOX * b,I_POINT p);

#endif
