/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <stdlib.h>
#include <string.h>

#include "v/VObject.h"
#include "v/VgbWPMenuEdit.h"
#include "v/vobj_utils.h"

extern "C" {
#include 	"xl.h"
#include	"xlerror.h"

XL_SEXP *
vobj_VgbWPMenuEdit(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
char * VgbWPMenuEdit_get_from_sf(VgbWPMenuEditStatus *,int*,XLISP_ENV*,L_CHAR *,XL_SYM_FIELD *,XL_SEXP*);
VImage *
get_image_from_lchar(XL_SEXP ** retp,XLISP_ENV * env,L_CHAR *,L_CHAR * _img_field);
XL_SEXP *
vobj_get_VgbWPMenuEdit(XLISP_ENV * env,XL_SEXP * arg,XLISP_ENV * a,XL_SYM_FIELD * sf);
int
get_flag_VgbWPMenuEdit(L_CHAR * fname);

char * VgbWPMenuEdit_get_from_sf(
	VgbWPMenuEditStatus * q_sts,
	int* q_flags,
	XLISP_ENV* env,
	L_CHAR * filepath,
	XL_SYM_FIELD * sf,
	XL_SEXP * arg)
{
L_CHAR * d;
XL_SEXP * _ret;
char * ret;
	*q_flags = 0;
	ret = 0;
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.qind.NewButton"));
	if ( d ) {
		q_sts->new_button_descriptor = ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_NEW_BUTTON_DESC;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.qind.DelButton"));
	if ( d ) {
		q_sts->del_button_descriptor = ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_DEL_BUTTON_DESC;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.qind.EditButton"));
	if ( d ) {
		q_sts->edit_button_descriptor =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_EDIT_BUTTON_DESC;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.Untitled"));
	if ( d ) {
		q_sts->untitled =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_UNTITLED;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.Details"));
	if ( d ) {
		q_sts->details =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_DETAILS;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.Close"));
	if ( d ) {
		q_sts->close =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_CLOSE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.WPConfigure"));
	if ( d ) {
		q_sts->wp_configure =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_WP_CONFIGURE;
	}


	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoItem"));
	if ( d ) {
		q_sts->info_item =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_ITEM;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoContent"));
	if ( d ) {
		q_sts->info_content =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_CONTENT;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoMenuTitle"));
	if ( d ) {
		q_sts->info_menu_title =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_MENU_TITLE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoMenuLink"));
	if ( d ) {
		q_sts->info_menu_link =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_MENU_LINK;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoType"));
	if ( d ) {
		q_sts->info_type =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_TYPE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoTitle"));
	if ( d ) {
		q_sts->info_title =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_TITLE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoTracking"));
	if ( d ) {
		q_sts->info_tracking =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_TRACKING;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoResolution"));
	if ( d ) {
		q_sts->info_resolution =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_RESOLUTION;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoRotate"));
	if ( d ) {
		q_sts->info_rotate =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_ROTATE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoCenter_x"));
	if ( d ) {
		q_sts->info_center_x =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_CENTER_X;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoCenter_y"));
	if ( d ) {
		q_sts->info_center_y =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_CENTER_Y;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoBase"));
	if ( d ) {
		q_sts->info_base =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_BASE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoLockBase"));
	if ( d ) {
		q_sts->info_lock_base =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_LOCK_BASE;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoLayerEntry"));
	if ( d ) {
		q_sts->info_layer_entry =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_LAYER_ENTRY;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.InfoLayerFlags"));
	if ( d ) {
		q_sts->info_layer_flags =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_INFO_LAYER_FLAGS;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.LoadMenuLink"));
	if ( d ) {
		q_sts->load_menu_link =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_LOAD_MENU_LINK;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.UnloadMenuLink"));
	if ( d ) {
		q_sts->unload_menu_link =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_UNLOAD_MENU_LINK;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.OpenInIndWindow"));
	if ( d ) {
		q_sts->open_in_ind_window =ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_OPEN_IN_IND_WINDOW;
	}

	d = get_sf_attribute(sf,l_string(std_cm,"wpme.LoadingTarget"));
	if ( d ) {
		q_sts->loading_target = ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_LOADING_TARGET;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.openFunc"));
	if ( d ) {
		q_sts->open_func = ll_copy_str(d);
		*q_flags |= VSF_GB_WPE_OPEN_FUNC;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.wpImg"));
	if ( d ) {
		q_sts->wp_img = get_image_from_lchar(&_ret,env,arg->h.file->name,d);
		if ( get_type(_ret) == XLT_ERROR ) {
			ret = "xltreeview.Img.raw";
			goto err;
		}
		*q_flags |= VSF_GB_WPE_WP_IMG;
	}
	d = get_sf_attribute(sf,l_string(std_cm,"wpme.wpgroupImg"));
	if ( d ) {
		q_sts->wpgroup_img = get_image_from_lchar(&_ret,env,arg->h.file->name,d);
		if ( get_type(_ret) == XLT_ERROR ) {
			ret = "xltreeview.Img.raw";
			goto err;
		}
		*q_flags |= VSF_GB_WPE_WPGROUP_IMG;
	}

	return 0;
err:
	return ret;
}

int
get_flag_VgbWPMenuEdit(L_CHAR * fname)
{
#define RET_FLAG(value, ff)  if ( l_strcmp(fname, l_string(std_cm, #value)) == 0 ) return ff
	RET_FLAG(wpme.Menu,VSF_GB_WPE_MENU);
	RET_FLAG(wpme.wpImg,VSF_GB_WPE_WP_IMG);
	RET_FLAG(wpme.wpgroupImg,VSF_GB_WPE_WPGROUP_IMG);
	RET_FLAG(wpme.qind.NewButton,VSF_GB_WPE_NEW_BUTTON_DESC);
	RET_FLAG(wpme.qind.DelButton,VSF_GB_WPE_DEL_BUTTON_DESC);
	RET_FLAG(wpme.qind.EditButton,VSF_GB_WPE_EDIT_BUTTON_DESC);
	RET_FLAG(wpme.LoadingTarget,VSF_GB_WPE_LOADING_TARGET);

	RET_FLAG(wpme.Untitled,VSF_GB_WPE_UNTITLED);
	RET_FLAG(wpme.Details,VSF_GB_WPE_DETAILS);
	RET_FLAG(wpme.Close,VSF_GB_WPE_CLOSE);
	RET_FLAG(wpme.WPConfigure,VSF_GB_WPE_WP_CONFIGURE);

	RET_FLAG(wpme.InfoItem,VSF_GB_WPE_INFO_ITEM);
	RET_FLAG(wpme.InfoContent,VSF_GB_WPE_INFO_CONTENT);
	RET_FLAG(wpme.InfoMenuTitle,VSF_GB_WPE_INFO_MENU_TITLE);
	RET_FLAG(wpme.InfoMenuLink,VSF_GB_WPE_INFO_MENU_LINK);
	RET_FLAG(wpme.InfoType,VSF_GB_WPE_INFO_TYPE);
	RET_FLAG(wpme.InfoTitle,VSF_GB_WPE_INFO_TITLE);
	RET_FLAG(wpme.InfoTracking,VSF_GB_WPE_INFO_TRACKING);
	RET_FLAG(wpme.InfoResolution,VSF_GB_WPE_INFO_RESOLUTION);
	RET_FLAG(wpme.InfoRotate,VSF_GB_WPE_INFO_ROTATE);
	RET_FLAG(wpme.InfoCenter_x,VSF_GB_WPE_INFO_CENTER_X);
	RET_FLAG(wpme.InfoCenter_y,VSF_GB_WPE_INFO_CENTER_Y);
	RET_FLAG(wpme.InfoBase,VSF_GB_WPE_INFO_BASE);
	RET_FLAG(wpme.InfoLockBase,VSF_GB_WPE_INFO_LOCK_BASE);
	RET_FLAG(wpme.InfoLayerEntry,VSF_GB_WPE_INFO_LAYER_ENTRY);
	RET_FLAG(wpme.InfoLayerFlags,VSF_GB_WPE_INFO_LAYER_FLAGS);
	RET_FLAG(wpme.OpenInIndWindow,VSF_GB_WPE_OPEN_IN_IND_WINDOW);
	RET_FLAG(wpme.UnloadMenuLink,VSF_GB_WPE_UNLOAD_MENU_LINK);
	RET_FLAG(wpme.LoadMenuLink,VSF_GB_WPE_LOAD_MENU_LINK);


	return 0;
}


XL_SEXP *
vobj_get_VgbWPMenuEdit(XLISP_ENV * env,XL_SEXP * arg,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
VStatusFlagsFromFS vsffs[2];
VObject * obj;
VgbWPMenuEditStatus q_sts;
VgbWPMenuEdit * q_obj;
XL_SEXP * ret,* ret2, * ret3;

	vsffs[0].get_flag = get_flag_VgbWPMenuEdit;
	vsffs[1].get_flag = 0;
	ret = _vobj_GetStatus(&obj,env,arg,a,sf,vsffs);
	if ( ret == 0 && obj == 0 )
		return ret;
	if ( get_type(ret) == XLT_ERROR || 
			(vsffs[0].flags == 0) )
		return ret;
	memset(&q_sts,0,sizeof(q_sts));
	q_obj = dynamic_cast<VgbWPMenuEdit*>(obj);
	q_obj->get_wpmedit_status(&q_sts,vsffs[0].flags);
	ret2 = 0;
	if ( vsffs[0].flags & VSF_GB_WPE_MENU ) {
		ret2 = cons(
			List(n_get_symbol("wpme.Menu"),
				wpm2sexp(q_sts.menu,1),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_NEW_BUTTON_DESC ) {
		ret2 = cons(
			List(n_get_symbol("wpme.qind.NewButton"),
				get_string(q_sts.new_button_descriptor),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_DEL_BUTTON_DESC ) {
		ret2 = cons(
			List(n_get_symbol("wpme.qind.DelButton"),
				get_string(q_sts.del_button_descriptor),
				-1),
			ret2);
	}

	if ( vsffs[0].flags & VSF_GB_WPE_EDIT_BUTTON_DESC ) {
		ret2 = cons(
			List(n_get_symbol("wpme.qind.EditButton"),
				get_string(q_sts.edit_button_descriptor),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_WP_CONFIGURE ) {
		ret2 = cons(
			List(n_get_symbol("wpme.WPConfigure"),
				get_string(q_sts.wp_configure),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_LOADING_TARGET ) {
		ret2 = cons(
			List(n_get_symbol("wpme.LoadingTarget"),
				get_string(q_sts.loading_target),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_OPEN_FUNC  ) {
		ret2 = cons(
			List(n_get_symbol("wpme.openFunc"),
				get_string(q_sts.open_func),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_WP_IMG ) {
		ret2 = cons(
			List(n_get_symbol("wpme.wpImg"),
				-1),
			ret2);
	}
	if ( vsffs[0].flags & VSF_GB_WPE_WPGROUP_IMG ) {
		ret2 = cons(
			List(n_get_symbol("wpme.wpgroupImg"),
				-1),
			ret2);
	}

	VgbWPMenuEdit::free_wpmedit_status(&q_sts);
	
	ret3 = vobj_get_VgbQueryIndicate(env,arg,a,sf);
	if ( get_type(ret3) == XLT_ERROR )
		return ret3;
	return append(append(ret,ret2),ret3);
}


XL_SEXP *
vobj_VgbWPMenuEdit(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
VExError ex_er;
VObjectStatus _sts;
VgbWPMenuEditStatus v_sts;
VgbQueryIndicateStatus qi_sts;
VxlTreeViewStatus tv_sts;
int v_flags,qi_flags,tv_flags;
char * param_ret;
XL_SEXP * p;
VObjectAppStatusAry app[4];
VgbWPMenuEdit * obj;

	if ( get_sf_attribute(sf,l_string(std_cm,"status")) ) {
		return vobj_get_VgbWPMenuEdit(env,arg,a,sf);
	}

	memset(&v_sts,0,sizeof(v_sts));
	memset(&tv_sts,0,sizeof(tv_sts));
	memset(&qi_sts,0,sizeof(qi_sts));
	
	param_ret = VgbWPMenuEdit_get_from_sf(&v_sts,&v_flags,env,
				arg->h.file->name,sf,arg);
	if ( param_ret )
		goto param_err;
	if ( list_length(arg) == 2 ) {
		v_sts.menu = sexp2wpm(get_el(arg,1));
		v_flags |= VSF_GB_WPE_MENU;
	}
	
	tv_flags = get_treeview_flags(&param_ret,&tv_sts,env,arg,sf);
	if ( param_ret )
		goto param_err;
	param_ret = VgbQueryIndicate_get_from_sf(&qi_sts,&qi_flags,env,
				arg->h.file->name,sf,arg);
	if ( param_ret )
		goto param_err;
	app[0].sts = (void*)&v_sts;
	app[0].flags = v_flags;
	app[1].sts = (void*)&tv_sts;
	app[1].flags = tv_flags;
	app[2].sts = (void*)&qi_sts;
	app[2].flags = qi_flags;
	app[3].sts = 0;
	app[3].flags = 0;
	p = get_refered_object<VgbWPMenuEdit>(&obj,env,arg,sf,
			VO_GQIN,"VgbWPMenuEdit",
			&_sts,0,app);
	if ( get_type(p) == XLT_ERROR ) {
		VgbWPMenuEdit::free_wpmedit_status(&v_sts);
		VgbQueryIndicate::free_queryindicate_status(&qi_sts);
		VxlTreeView::free_VxlTreeViewStatus(&tv_sts);
		return p;
	}
	VgbWPMenuEdit::free_wpmedit_status(&v_sts);
	VgbQueryIndicate::free_queryindicate_status(&qi_sts);
	VxlTreeView::free_VxlTreeViewStatus(&tv_sts);
	return 0;
//err2:
	obj->destroy();
	VgbWPMenuEdit::free_wpmedit_status(&v_sts);
	VgbQueryIndicate::free_queryindicate_status(&qi_sts);
	VxlTreeView::free_VxlTreeViewStatus(&tv_sts);
	return vobj_get_error(ex_er, arg,0);
param_err:
	VgbWPMenuEdit::free_wpmedit_status(&v_sts);
	VgbQueryIndicate::free_queryindicate_status(&qi_sts);
	VxlTreeView::free_VxlTreeViewStatus(&tv_sts);
	return get_error(
		arg->h.file,
		arg->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"VgbWPMenuEdit"),
		List(n_get_string("invalid param of attribute ::"),
			n_get_string(param_ret),
			-1));
}

void
init_vobj_VgbWPMenuEdit(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VgbWPMenuEdit"),
		get_func_prim((XL_SEXP*(*)())vobj_VgbWPMenuEdit,FO_APPLICATIVE,0,1,2));
	set_env(env,l_string(std_cm,"VMT-WARP-EDIT-NEW-GROUP"),
		n_get_string(VMT_WARP_EDIT_NEW_GROUP_STR));
}


} // extern "C"
