/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <string.h>
#include <stdlib.h>

#include "v/VChooseFile.h"

extern "C" {

#include "xl.h"
#include "xlerror.h"
#include "memory_debug.h"

XL_SEXP * vobj_VChooseFile(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);

XL_SEXP *
vobj_VChooseFile(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	L_CHAR *title = get_sf_attribute(sf, l_string(std_cm, "title"));
	L_CHAR *def = get_sf_attribute(sf, l_string(std_cm, "default"));
	
	char *ret = v_choose_file(title, def ? n_string(std_cm, def) : 0);
	return ret ? n_get_string(ret) : 0;
}

void
init_VChooseFile(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VChooseFile"),
		get_func_prim((XL_SEXP*(*)())vobj_VChooseFile,FO_NORMAL,0,1,1));
}

} // extern "C"
