/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_GetAllAS();

void
init_GetAllAS(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetAllAS"),
		get_func_prim(xl_GetAllAS,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_GetAllAS(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{

int key,index;

ASSOC_STRING_OPT s_opt;
int s_opt_f;

	key = -1;
	index = -1;
	s_opt_f = 0;

	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"key")) == 0 ) {
			sscanf(n_string(std_cm,sf->data),"%i",&key);
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"index")) == 0 ) {
			sscanf(n_string(std_cm,sf->data),"%i",&index);
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"stropt")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,"fit")) == 0 ) {
				s_opt.flags = 1;
				s_opt_f = 1;
			}
			else {
				s_opt.flags = 0;
				s_opt_f = 1;
			}
		}
	}
	return get_assoc_all(key,index);
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetAllAS"),
		n_get_string("type missmatch"));
cannot_insert:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"GetAllAS"),
		n_get_string("insert error"));
*/
}

