/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"

XL_SEXP *
base_list(XL_SEXP * inp)
{
XL_SEXP * a,*b,* c,*d;
	if ( get_type(inp) != XLT_PAIR )
		return inp;
	c = 0;
	for ( a = inp ; get_type(a) == XLT_PAIR ; a = cdr(a) ) {
		b = base_list(car(a));
		switch ( get_type(b) ) {
		case XLT_PAIR:
			d = car(b);
			if ( get_type(d) == XLT_SYMBOL )
				c = append(c,List(b,-1));
			else	c = append(c,b);
		case XLT_NULL:
			break;
		default:
			c = append(c,List(b,-1));
		}
	}
	return c;
}


XL_SEXP *
cut_null(XL_SEXP * inp)
{
XL_SEXP * a,* ret;
int f;
	if ( get_type(inp) == XLT_PAIR ) {
		ret = 0;
		f = 0;
		for ( ; get_type(inp) == XLT_PAIR ; inp = cdr(inp) ) {
			a = cut_null(car(inp));
			switch ( get_type(a) ) {
			case XLT_NULL:
				continue;
			case XLT_SYMBOL:
				if ( f == 0 ) {
					f = 1;
					break;
				}
				a = cast_symbol2string(a);
				break;
			default:
				break;
			}
			ret = cons(a,ret);
		}
		return reverse(ret);
	}
	else {
		return inp;
	}
}


XL_SEXP *
format_HTML(XL_SEXP * inp)
{
	return base_list(cut_null(inp));
}


XL_SEXP *
xl_format_HTML(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
	return format_HTML(get_el(s,1));
}

