/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"utils.h"
#include	"memory_debug.h"

#include	<mbstring.h>

void
swap_delim_str(char * dst, const char * src)
{
//	const unsigned char *src_ = (const unsigned char *)src;
	for(; *src; ){
		unsigned int nextc = _mbsnextc(src);
		
		if(nextc == '\\'){
			*dst++ = '/';
			++src;
		}
		else if(nextc == '/'){
			*dst++ = '\\';
			++src;
		}
		else{
			const unsigned char *nextPtr = _mbsinc(src);
			int bytes = nextPtr-src;
			memcpy(dst, src, bytes);
			dst += bytes;
			src += bytes;
		}
	}
	*dst = '\0';

	/*
    do {
        switch ( *src ) {

        case '/':
            src++;
            *dst++ = '\\';
            break;
        case '\\':
            src++;
            *dst++ = '/';
            break;
        default:
            *dst++ = *src++;
        }
    } while ( *(src-1) );
	*/
}


char *
change_delim_str(const char * buf)
{
int len = strlen(buf);
const char * ptr;
char * ret, * dst;
	
	ptr = buf;
	ret = dst = d_alloc(len+1);

	if ( buf[0] == '/' ) {
		ptr++;
	}

	swap_delim_str(dst,ptr);
	return ret;
}


char*
normalize_delim_str(const char * buf)
{
const char * ptr;
char * ret, * dst;
	
	ret = dst = d_alloc(strlen(buf)+2);

	for ( ptr = buf ; *ptr && *ptr != '\\' ; ptr++ ) {
		if ( *ptr == ':' ) {
			*dst++ = '/';
		}
	}
	
	swap_delim_str(dst,buf);
	return ret;
}

