/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"v.h"
#include	"gbgraph.h"
#include	"viewindex.h"
#include	"memory_debug.h"


GB_POINT
v2gb_point(I_POINT v)
{
GB_POINT ret;
	ret.x = v.x;
	ret.y = v.y;
	return ret;
}


void
index_move(unsigned long * dest,unsigned long * src,
		I_POINT * index,int w,int h,unsigned long no_data,
		unsigned long dirty_bit)
{
int x,y;
	for ( y = 0 ; y < h ; y ++ )
		for ( x = 0 ; x < w ; x ++ , dest ++ , index ++ ) {
			if ( index->x < 0 )
				goto no_data;
			if ( index->y < 0 )
				goto no_data;
			*dest = src[index->x + index->y * w]|dirty_bit;
			continue;
		no_data:
			*dest = no_data;
		}
}


unsigned long *
index_move_small(I_RECT * ret,unsigned long * src,
		I_RECT src_rct,
		I_POINT * index,int w,int h,
		unsigned long no_data,
		unsigned long dirty_bit)
{
int x,y;
I_POINT * ix_ptr;
int width,height;
I_RECT new_rct;
unsigned long * t_ptr, * target;
int xx,yy;

	new_rct.tl.x = new_rct.tl.y = 0;
	new_rct.br.x = new_rct.br.y = -1;

	ix_ptr = index;
	for ( y = 0 ; y < h ; y ++ ) {
		for ( x = 0 ; x < w ; x ++ , ix_ptr ++ ) {
			if ( ix_ptr->x < 0 )
				continue;
			if ( ix_ptr->x < src_rct.tl.x )
				continue;
			if ( ix_ptr->x >= src_rct.br.x )
				continue;
			if ( ix_ptr->y < src_rct.tl.y )
				continue;
			if ( ix_ptr->y >= src_rct.br.y )
				continue;
			if ( new_rct.tl.x > new_rct.br.x ) {
				new_rct.tl.x = x;
				new_rct.tl.y = y;
				new_rct.br.x = x+1;
				new_rct.br.y = y+1;
			}
			else {
				if ( x < new_rct.tl.x )
					new_rct.tl.x = x;
				else if ( x >= new_rct.br.x )
					new_rct.br.x = x+1;
				if ( y < new_rct.tl.y )
					new_rct.tl.y = y;
				else if ( y >= new_rct.br.y )
					new_rct.br.y = y+1;
			}
		}
	}
	if ( new_rct.tl.x > new_rct.br.x || new_rct.tl.y > new_rct.br.y ) {
		new_rct = src_rct;
	}

	width = (src_rct.br.x - src_rct.tl.x);
	height = (src_rct.br.y - src_rct.tl.y);
	
	target = d_alloc(sizeof(unsigned long)*(new_rct.br.x - new_rct.tl.x)*(new_rct.br.y - new_rct.tl.y));
	t_ptr = target;
	ix_ptr = index;
	for ( y = new_rct.tl.y ; y < new_rct.br.y ; y ++ ) {
		for ( x = new_rct.tl.x ; x < new_rct.br.x ; x ++ , ix_ptr ++ ) {
			yy = ix_ptr->y - src_rct.tl.y;
			xx = ix_ptr->x - src_rct.tl.x;
			if ( yy < 0 || xx < 0 )
				*t_ptr = no_data;
			else if ( yy >= height || xx >= width )
				*t_ptr = no_data;
			else	*t_ptr = src[xx + yy * width]|dirty_bit;
			t_ptr ++;
		}
	}
	*ret = new_rct;
	return target;
}

