/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "win_flame.h"
#include "xlerror.h"
#include "radar.h"

XL_SEXP * xl_gv_flame_loading_status();
XL_SEXP * loading_status2list(LOADING_STATUS * ls);

void
init_gv_flame_loading_status(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-loading-status"),
			get_func_prim(xl_gv_flame_loading_status,
			FO_APPLICATIVE,0,1,1));
}

XL_SEXP * loading_status2list(LOADING_STATUS * ls)
{
XL_SEXP * rc = 0;
XL_SEXP * wf = 0;
int i;
XL_SEXP * lst;
int all;
	all = 0;
	rc = cons(List(n_get_symbol("status"),
			get_integer(ls->rc.status,0),
			-1),rc);
	rc = cons(List(n_get_symbol("search-loading"),
			get_integer(ls->rc.search_loading,0),
			-1),rc);
	all += ls->rc.search_loading;
	rc = cons(List(n_get_symbol("layer-management"),
			get_integer(ls->rc.layer_management,0),
			-1),rc);
	all += ls->rc.layer_management;
	rc = cons(List(n_get_symbol("change-base-coord"),
			get_integer(ls->rc.change_base_coord,0),
			-1),rc);
	all += ls->rc.change_base_coord;
	rc = cons(List(n_get_symbol("beam"),
			get_integer(ls->rc.ri.d.beam,0),
			-1),rc);
	all += ls->rc.ri.d.beam;
	lst = 0;
	for ( i = CRT_MAX ; i >= 0 ; i -- ) {
		lst = cons(get_integer(ls->rc.ri.d.loading_res[i],0),
				lst);
		all += ls->rc.ri.d.loading_res[i];
	}
	rc = cons(cons(n_get_symbol("loading-res"),lst),rc);
	
	lst = 0;
	for ( i = CRT_MAX ; i >= 0 ; i -- ) {
		lst = cons(get_integer(ls->rc.ri.d.ready_res[i],0),
				lst);
		all += ls->rc.ri.d.ready_res[i];
	}
	rc = cons(cons(n_get_symbol("ready-res"),lst),rc);
	
	rc = cons(List(n_get_symbol("load-to-beam"),
			get_integer(ls->rc.ri.d.load_to_beam,0),
			-1),rc);
	all += ls->rc.ri.d.load_to_beam;
	rc = cons(List(n_get_symbol("beam-to-resource"),
			get_integer(ls->rc.ri.d.beam_to_resource,0),
			-1),rc);
	all += ls->rc.ri.d.beam_to_resource;
	rc = cons(List(n_get_symbol("retrieve1"),
			get_integer(ls->rc.ri.d.retrieve1,0),
			-1),rc);
	all += ls->rc.ri.d.retrieve1;
	rc = cons(List(n_get_symbol("retrieve2"),
			get_integer(ls->rc.ri.d.retrieve2,0),
			-1),rc);
	all += ls->rc.ri.d.retrieve2;

	rc = cons(n_get_symbol("rc"),rc);

	wf = cons(List(n_get_symbol("draw"),
			get_integer(ls->wf.draw,0),
			-1),wf);
	all += ls->wf.draw;
	wf = cons(List(n_get_symbol("exit"),
			get_integer(ls->wf.exit,0),
			-1),wf);
	all += ls->wf.exit;
	wf = cons(List(n_get_symbol("load-structure"),
			get_integer(ls->wf.load_structure,0),
			-1),wf);
	all += ls->wf.load_structure;
	wf = cons(List(n_get_symbol("dirty"),
			get_integer(ls->wf.dirty,0),
			-1),wf);
	wf = cons(List(n_get_symbol("data-request"),
			get_integer(ls->wf.data_request,0),
			-1),wf);
	all += ls->wf.data_request;
	wf = cons(List(n_get_symbol("indicate-request"),
			get_integer(ls->wf.indicate_request,0),
			-1),wf);
	all += ls->wf.indicate_request;
	wf = cons(List(n_get_symbol("indicate"),
			get_integer(ls->wf.indicate,0),
			-1),wf);
	all += ls->wf.indicate;
	wf = cons(List(n_get_symbol("raw-image-request"),
			get_integer(ls->wf.raw_image_request,0),
			-1),wf);
	all += ls->wf.raw_image_request;

	wf = cons(n_get_symbol("wf"),wf);

	return List(
		n_get_symbol("loading-status"),
		List(n_get_symbol("all"),
			get_integer(all,0),
			-1),
		rc,wf,-1);
}



XL_SEXP *
xl_gv_flame_loading_status(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a,
		XL_SYM_FIELD * sf)
{
GBVIEW_FLAME * gf;
LOADING_STATUS ls;
GBVIEW_STATUS sts;
int ret;
	
	gf = get_gf_from_sf(sf);

	ret = get_rc_loading_status(
		(RADAR_CACHE*)gf->radar_ptr,&ls.rc);
	if ( ret < 0 )
		goto invalid_obj;
	wf_status(gf,&sts);
	ls.wf = sts.loading_status;
	wf_free_status(&sts);
	return loading_status2list(&ls);;


invalid_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"gv-flame-loading-status"),
		List(n_get_string("invalid GF"),
			-1));
}
