/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___U_FILE_H___
#define ___U_FILE_H___

#ifdef __cplusplus
extern "C" {
#endif

/*
#define u_lseek64_DEBUG
*/

#include	"machine/include.h"
#include	"u_history.h"

#define UTC_00_00_00_01_01_2001	978307200

#define TFMT_UNIX	1
#define TFMT_W3C_DTF	2

typedef struct _sys_param {
	unsigned int		cpu;
	unsigned int		max_fd;
	INTEGER64		init_mem_size;
} _SYS_PARAM;

typedef struct _u_stat {
	unsigned long		us_mode;
	uid_t			us_uid;
	gid_t			us_gid;
	unsigned int		us_atime;
	unsigned int		us_mtime;
	unsigned int		us_ctime;
} U_STAT;

typedef struct u_ck_buf {
	int			lev_mask;
	unsigned int		w_checksum[2];
	int *			u_history[2];
} U_CK_BUF;

extern _SYS_PARAM	sys_param;

int u_stat(char * path,U_STAT * buf);


#ifndef U_FILE_LIB
int u_open(char *,int,...);
int u_open64(char *,int,...);
#else 
int u_open(char * filename,int flags,int mode);
int u_open64(char * filename,int flags,int mode);
#endif
int u_close(int);
int u_write(int,void *,int);
int u_read(int,void*,int);
int u_lseek(int,int,int);
#ifndef u_lseek64_DEBUG
INTEGER64 u_lseek64(int,INTEGER64,int);
#else
INTEGER64 u_xx_lseek64(int,INTEGER64,int,char * file,int line);
#define u_lseek64(a,b,c)	u_xx_lseek64((a),(b),(c),__FILE__,__LINE__)
#endif

int u_unlink(char*);
int u_rmdir(char*);
int u_checksum(int,U_CK_BUF*);

void set_sys_param();
INTEGER64 _get_mem_size();
INTEGER64 get_mem_size();
INTEGER64 get_usedmemory_size();
unsigned int get_fd_max();
int set_fd_max(unsigned int);
int numofcpu();
char * u_getenv(char*);

int get_checksum(int,unsigned int *,int **);
void set_checksum(int,void *,int);
int free_checksum(int);


extern int open_err_sub_code;
extern int u_open_point;
extern int ufr_point;
extern int open_err_main_code;


#ifdef __cplusplus
}
#endif


#endif


