/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_GB_FLAME_H___
#define ___V_GB_FLAME_H___


extern "C" {
#include	"gbgraph.h"
}

#include	"v/VMacro.h"
#include	"v/VButton.h"
#include	"v/VDraw.h"
#include	"v/VgbIndicate.h"
#include	"v/VxlTreeView.h"
#include	"v/VMarshaler.h"
#include	"v/VMenu.h"

#include	"v/v_switch.h"

#define VMT_WARP		VMT_CONV(-10100)
#define VMT_WARP_STR		VMT_STR(-10100)
#define VMT_ADD_WARP		VMT_CONV(-10101)
#define VMT_ADD_WARP_STR	VMT_STR(-10101)
#define VMT_EDIT_WARP		VMT_CONV(-10102)
#define VMT_EDIT_WARP_STR	VMT_STR(-10102)
#define VMT_WARP_REPLACE_MODE	VMT_CONV(-10103)
#define VMT_WARP_REPLACE_MODE_STR VMT_STR(-10103)
#define VMT_WARP_INSERT_MODE	VMT_CONV(-10104)
#define VMT_WARP_INSERT_MODE_STR VMT_STR(-10104)

#define VMT_WARP_ENTRY_MIN_ABS	VMT_CONV(-11000)

#define VMT_WARP_ENTRY_MAX_ABS	VMT_CONV(-13000)

#define VSF_FLAME_STYLE			(1<<0)
#define VSF_FLAME_DEFAULT_WS		(1<<1)
#define VSF_FLAME_ZOOM_IN		(1<<2)
#define VSF_FLAME_ZOOM_OUT		(1<<3)
#define VSF_FLAME_GRAB_MODE_BUTTON	(1<<4)
#define VSF_FLAME_ROTATE_MODE_BUTTON	(1<<5)
#define VSF_FLAME_CLICK_MODE_BUTTON	(1<<6)
#define VSF_FLAME_BUTTONS_CONTROL	(1<<7)
#define VSF_FLAME_INDICATE_OBJ		(1<<8)
#define VSF_FLAME_INDICATE_TREE_OBJ	(1<<9)
#define VSF_FLAME_INDICATE_TREE_EYE	(1<<10)
#define VSF_FLAME_INDICATE_TREE_INFO	(1<<11)
#define VSF_FLAME_INDICATE_TREE_BASE	(1<<12)
#define VSF_FLAME_INDICATE_TREE_WEB	(1<<13)
#define VSF_FLAME_OATTRIBUTE_HANDLER	(1<<14)
#define VSF_FLAME_SELECT_MODE		(1<<15)
#define VSF_FLAME_RELATED_FLAME		(1<<16)
#define VSF_FLAME_FOCUS			(1<<17)

typedef struct _VgbFlameStatus {
	int			style;
#define VGB_STYLE_ON_FLAME_BTN	1
#define VGB_STYLE_EX_FLAME_BTN	2
#define VGB_STYLE_MAX		3


	LC_WRITING_STYLE *	default_ws;

	VButton *		zoom_in;
	VButton *		zoom_out;
	VRadioButton *		grab_mode_button;
	VRadioButton *		rotate_mode_button;
	VRadioButton *		click_mode_button;

	VMarshaler *		buttons_control;

	VgbIndicate *		indicate_obj;
	VxlTreeView *		indicate_tree_obj;

	VImage *		indicate_tree_eye;
	VRect			indicate_tree_eye_elr[2];
	VImage *		indicate_tree_info;
	VRect			indicate_tree_info_elr[2];
	VImage *		indicate_tree_base;
	VRect			indicate_tree_base_elr[5];
	VImage *		indicate_tree_web;
	VRect			indicate_tree_web_elr[3];

	V_CALLBACK		(oattribute_handler);
	void *			oattribute_handler_arg;

	int			select_mode;
#define VGB_MODE_GRAB	1
#define VGB_MODE_ROTATE	2
#define VGB_MODE_CLICK	3

	VObject *		related_flame;
} VgbFlameStatus;

#define VM_MODE		0
#define VM_ZOOM_IN	1
#define VM_ZOOM_OUT	2
#define VM_LEFT_ARROW	3
#define VM_RIGHT_ARROW	4
#define VM_W3_INFO	5
#define VM_WARP		6

#define VMB_MODE_GRAB	0
#define VMB_MODE_ROTATE	1
#define VMB_ZOOMIN	2
#define VMB_ZOOMOUT	3
#define VMB_LEFT_ARROW	4
#define VMB_RIGHT_ARROW	5
#define VMB_W3INFO	6
#define VMB_WARP	7

#define VSF_FLAME_C_STATUS			(1<<0)
#define VSF_FLAME_C_LAYER_NOS			(1<<1)
#define VSF_FLAME_C_FLAME_BASE_RECT		(1<<2)
#define VSF_FLAME_C_FLAME_BASE_CENTER		(1<<3)
#define VSF_FLAME_C_FLAME_BASE_ROTATE		(1<<4)
#define VSF_FLAME_C_FLAME_BASE_RESOLUTION 	(1<<5)
#define VSF_FLAME_C_FLAME_BASE_UNIT		(1<<6)
#define VSF_FLAME_C_FLAME_BASE_DISPLAY_MAP_TYPE	(1<<7)
#define VSF_FLAME_C_CURRENT			(1<<8)
#define VSF_FLAME_C_LAYERS			(1<<9)
#define VSF_FLAME_C_PP_RADIUS			(1<<10)
#define VSF_FLAME_C_TARGET			(1<<11)

typedef struct _VgbFlameLayers {
	struct _VgbFlameLayers *	next;
	WF_ID				id;
	L_CHAR * 			entry_url;
	L_CHAR *			target_url;
	int				flags;
} VgbFlameLayers;

typedef struct _VgbFlameCoordinateStatus {
	int		status;
	int		layer_nos;

	GB_RECT		flame_base_rect;

	GB_POINT	flame_base_center;
	REAL1		flame_base_rotate;
	REAL1		flame_base_resolution;
	L_CHAR *	flame_base_unit;
	int		flame_base_display_map_type;
	WF_ID		current;

	VgbFlameLayers *	layers;

	/* option */

	REAL1		pp_radius;
	L_CHAR *	target;
} VgbFlameCoordinateStatus;


#define VSF_FLAME_R_QUERY_GET		(1<<0)
#define VSF_FLAME_R_QUERY_SET		(1<<1)
#define VSF_FLAME_R_QUERY_REPLACE	(1<<2)
#define VSF_FLAME_R_QUERY_INSERT	(1<<3)
#define VSF_FLAME_R_QUERY_DELETE_BYNO	(1<<4)
#define VSF_FLAME_R_EVENT_HANDLER	(1<<5)
#define VSF_FLAME_R_LOADING_STATUS	(1<<6)

typedef struct _VgbFlameRadarStatus {
	QUERY_THREAD *		query_set;
	QUERY_THREAD *		query_insert;
	QUERY_THREAD *		query_replace;
	int			delete_byno;
	int			result;
	QUERY_THREAD *		result_query;

	void 			(*event_handler)(QUERY_THREAD*,void*);
	void *			eh_user_arg;

	LOADING_STATUS		loading_status;
} VgbFlameRadarStatus;

#define VSF_FLAME_S_FORMAT	(1<<0)
#define VSF_FLAME_S_QUALITY	(1<<1)
#define VSF_FLAME_S_PERIPHERAL	(1<<2)
#define VSF_FLAME_S_PARAMETER	(1<<3)
#define VSF_FLAME_S_AGENT_URL	(1<<4)
#define VSF_FLAME_S_MODE	(1<<5)

typedef struct _VgbFlameSwtichStatus {
	L_CHAR *		format;
	L_CHAR *		quality;
	L_CHAR * 		peripheral;
	L_CHAR *		parameter;
	L_CHAR * 		agent_url;
	int			mode;
} VgbFlameSwitchStatus;

#define VGB_DRAG_MOVE	1
#define VGB_DRAG_ZOOM	2

typedef struct pi_xy {
	int		type;
#define PIT_XY		1
	int *		index_x;
	int *		index_y;
} PI_XY;

typedef struct pi_plane {
	int		type;
#define PIT_PLANE	2
	I_POINT *	index;
} PI_PLANE;

typedef union ptr_index {
	int		type;
	PI_PLANE	p;
	PI_XY		xy;
} PTR_INDEX;

typedef struct move_set {
	int		(*param_func)(struct flame_work *,void **);
	int		(*flame_func)(struct flame_work *);
	int 		(*index_func)(struct flame_work *);
	int		(*cmp_func)(struct flame_work *,void*,void*);
} MOVE_SET;

typedef struct tv_shadow {
	int		flags;
	RESOURCE * 	r;
	VStaticText *	main_text;
	VStaticText *	chi_text;
	L_CHAR *	homepage;
	VexDraw *	eye;
	VexDraw *	info;
	VexDraw *	base;
	VexDraw *	web;
	VBackColorView *	main_bc;
	VBackColorView *	chi_bc;
} TV_SHADOW;

typedef struct warp_point_menu {
	int				id;
	unsigned			submenu_type:4;
#define WPM_ST_NONE		0
#define WPM_ST_NORMAL		1
#define WPM_ST_FILE		2
#define WPM_ST_NET		3

#define WPM_ST_HELPER		8

#define WPM_ST_LOAD_MENU	15
	L_CHAR *			name;
	L_CHAR *			path;
	struct warp_point_menu *	submenu;
	WARP_POINT *			wp;
	struct warp_point_menu *	next;
} WARP_POINT_MENU;

typedef struct flame_work {
	class VgbFlameStandard *	this_object;

	VgbFlameStatus	sts;

	TV_SHADOW *			tree_view_data;
	int				tree_view_data_len;
	int				tree_view_data_dir;
	VImage *			tree_view_eye[2];
	VImage *			tree_view_info[2];
	VImage *			tree_view_base[5];
	VImage *			tree_view_web[3];
	
	V_CALLBACK			(oattribute_handler);
	void *				oattribute_handler_arg;

	VgbFlameSwitchStatus sw_sts;
	FLAME_SWITCH	sw;

	int		fw_active;

	VFocusView *	focus;
	VDraw *		im;

	int		seq;
	int		seq_lock;

	int		select_mode_lock;
	char *		select_mode_lock_file;
	int		select_mode_lock_line;

	int		redraw_flag;
	
	int		im_out_off;

	int		mode;

#define GBM_IDLE		0
#define GBM_PRESS_IMAGE		0x01
#define GBM_MOVE_IMAGE		0x02
#define GBM_PRESS_ZOOM_IN	0x04
#define GBM_PRESS_ZOOM_OUT	0x08
#define GBM_PRESS_MODE_BTN	0x10

#define GBM_PRESS		(GBM_PRESS_IMAGE|GBM_MOVE_IMAGE)

	unsigned	warp_mode:1;
#define WM_REPLACE	0
#define WM_INSERT	1
	unsigned	in_focus:1;

	VPoint		press;
	REAL1		press_zoom;
	int		press_time;

	VPoint		instop_pt;
	int		instop_time;
	unsigned	instop_in:1;
	unsigned 	instop_task:1;
	VPoint		instop_update;

	VImage *	ss;
	PTR_INDEX	ix;
	void *		last_shot;
	void *		start_shot;
	MOVE_SET *	ms;

	I_POINT		select_st;
	I_POINT		select_end;
	int		select_flag;

	RADAR_INDICATE	ri;
	
	XL_SEXP *	instop_html;
	
	L_CHAR *	win_title;
} FLAME_WORK;


typedef struct vgb_flame_t {
	Q_HEADER	h;
	int		type;
#define VGBFT_INSERT	0
#define VGBFT_CHANGE_BASE 1
#define VGBFT_POINT	2
#define VGBFT_B_CLICK	3
#define VGBFT_INFOLIST	4
	FLAME_WORK *	fw;
	VPoint		pt;
	INFO_LIST *	infolist;
} VGB_FLAME_T;


class VgbFlame : public VMacro
{
  public:
	enum { object_type = VO_GFLM };

	virtual unsigned	get_type() const { return object_type; }

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_flame_status(
				VgbFlameStatus *,
				int flags) const;
	virtual VExError set_flame_status(
				const VgbFlameStatus *,
				int flags);
	
	virtual VExError get_coordinate_status(
				VgbFlameCoordinateStatus *,
				int flags) const;
	virtual VExError set_coordinate_status(
				const VgbFlameCoordinateStatus *,
				int flags);

	virtual VExError get_radar_status(
				VgbFlameRadarStatus *,
				int flags) const;
	virtual VExError set_radar_status(
				VgbFlameRadarStatus *,
				int flags);
	
	virtual VExError get_switch_status(VgbFlameSwitchStatus *,int flags) const;
	virtual VExError set_switch_status(const VgbFlameSwitchStatus *,int flags);
	
	virtual VError	drag(int type,VPoint start,VPoint end);

	virtual VExError create_do_out_of_lock(
		const VObjectStatus *,int flags,VObject * nmp,void * arg);
	
	// XL gc processing if using XL_SEXP in VObject
	//	defined by each VMacro Object
	virtual	void gc() {}

  protected:

  	virtual ~VgbFlame();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);

};

class VgbFlameStandard : public VgbFlame
{
  public:
	enum { object_type = VO_GFLM };
	virtual unsigned	get_type() const { return object_type; }
		
	static VgbFlameStandard*
	create(const VObjectStatus *s, int flags, VExError* err=0) {
		return create(s, flags, 0, err);
	}
	static VgbFlameStandard*
	create(const VObjectStatus *s, int flags, void * arg, VExError* err) {
		return static_cast<VgbFlameStandard*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual VExError get_flame_status(
				VgbFlameStatus *,
				int flags) const;
	virtual VExError set_flame_status(
				const VgbFlameStatus *,
				int flags);

	virtual VExError get_radar_status(
				VgbFlameRadarStatus *,
				int flags) const;
	virtual VExError set_radar_status(
				VgbFlameRadarStatus *,
				int flags);

	virtual VExError get_switch_status(VgbFlameSwitchStatus *,int flags) const;
	virtual VExError set_switch_status(const VgbFlameSwitchStatus *,int flags);
	

	virtual VExError get_coordinate_status(
				VgbFlameCoordinateStatus *,
				int flags) const;
	virtual VExError set_coordinate_status(
				const VgbFlameCoordinateStatus *,
				int flags);

	virtual VExError create_do_out_of_lock(
		const VObjectStatus *,int flags,VObject * nmp,void * arg);

//	virtual VError	drag(int type,VPoint start,VPoint end);

	virtual void _vfq_event_task_insert(VGB_FLAME_T *);
	virtual void _vfq_event_task_point(VGB_FLAME_T *);
	virtual void _vfq_event_task_change_base(VGB_FLAME_T*);
	virtual void _eye_handler(VObject*);
	virtual void _base_handler(VObject*);
	virtual void _info_handler(VObject*);
	virtual void _web_handler(VObject*);
	virtual int _flame_focus_handler(int edit_type,int len,VBackColorView ** bcl);
	virtual void _flame_focus_command_status();
	virtual void _flame_focus_obey_command(int type);
	void _set_warp_point_menu();
	void _warp_point(WARP_POINT*);
	void _initial_menu_set(VWindow * win);
	void _final_menu_set(VWindow * win);
	void _initial_focus_set(VWindow * win);
	void _final_focus_set(VWindow * win);
	void _warp_point_callback_mode(int);
	static WARP_POINT_MENU * get_wpm();
	static void set_wpm(WARP_POINT_MENU*);

	// XL gc processing if using XL_SEXP in VObject
	//	defined by each VMacro Object
	virtual	void gc();

	typedef struct _lml {
		struct _lml *		next;
		L_CHAR *		target;
		WARP_POINT_MENU *	wpm;
		VgbFlameStandard *	obj;
		int			mode;
#define _LML_INITIAL	1
#define _LML_MENU	2
		unsigned		end_flag:1;
	} _LML;

	static void _load_menu_link_s(XL_SEXP * ret,L_CHAR * target,void*user_arg);
	static int _load_menu_link(WARP_POINT_MENU * wpm,_LML * t);
	
	void _load_menu_link_initial(WARP_POINT_MENU * wpm);




  protected:

  	virtual ~VgbFlameStandard();
	
	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

	FLAME_WORK	fw;

  private:
	static VObject *internal_new(){
	VgbFlameStandard * ret;
		ret = new VgbFlameStandard();
		return ret;
	}
};

void free_VgbFlameLayers(VgbFlameLayers * l);
void free_VgbFlameCoordinateStatus(struct _VgbFlameCoordinateStatus *,int);
extern "C" XL_SEXP *
wpm2sexp_1(WARP_POINT_MENU * m);
extern "C" XL_SEXP *
wpm2sexp(WARP_POINT_MENU * m,int tag_flag);
extern "C" WARP_POINT_MENU *
sexp2wpm_1(XL_SEXP * s);
extern "C" WARP_POINT_MENU *
sexp2wpm(XL_SEXP * s);
extern "C" void
VgbFlame_save_preference_wpm();
extern "C" void
xx_free_wpm_1(WARP_POINT_MENU * m,char * f,int ln);
extern "C" void
xx_free_wpm(WARP_POINT_MENU* m,char * f,int ln);

#define free_wpm(w)	xx_free_wpm((w),__FILE__,__LINE__)
#define free_wpm_1(w)	xx_free_wpm_1((w),__FILE__,__LINE__)
extern "C" WARP_POINT_MENU*
copy_wpm(WARP_POINT_MENU* m);
extern "C" int
VgbFlame_load_wpm(L_CHAR * filename,int flag);
L_CHAR * 
get_title_string(FLAME_SWITCH * sw,L_CHAR * url,int type);
#define GTF_URL		0x00000001
#define	GTF_TITLE	0x00000002
extern "C" void
print_wpm(char*,WARP_POINT_MENU * w);
extern "C" int
VgbFlame_set_wpm(WARP_POINT_MENU * wpm,int flag);


#endif
