/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_SWITCH_H___
#define ___V_SWITCH_H___

#ifdef __cplusplus
extern "C" {
#endif

#include	"gbview.h"
#include	"radar.h"

typedef struct flame_switch {
	struct flame_switch * next;
	GBVIEW_FLAME *	gf;
	int		id;
	L_CHAR * gv_redraw_format;
	L_CHAR * gv_redraw_quality;

	int	mode;
#define SW_MODE_IDLE	0
#define SW_MODE_LOCAL	1
#define SW_MODE_REMOTE	2
	URL view_agent_url;
	L_CHAR * peripheral;
	L_CHAR * parameter;

	// system working area

	int view_agent_id;
	int view_agent_ses;
	int gvagent_need_redraw;
	int call_sts_cache_valid;
	GBVIEW_STATUS	sts_cache;
	void (*sw_event_func)(GBVIEW_FLAME * ,int,void *,void*);
	void * sw_event_user_arg;
	void (*sw_ri_event_func)(RADAR_INDICATE*,void*);
	void * sw_ri_event_user_arg;
	void (*sw_rc_event_func)(QUERY_THREAD*,void*);
	void * sw_rc_event_user_arg;
} FLAME_SWITCH;



#define CALL_STS_CACHE_NORMAL 1
#define CALL_STS_CACHE_REFRESH 2

int call_wf_status(FLAME_SWITCH * sw,GBVIEW_STATUS * e, int call_sts_cache_flag);
int call_wf_set_status(FLAME_SWITCH * sw,GBVIEW_STATUS * e);
int call_wf_click(FLAME_SWITCH * sw,GBVIEW_STATUS * sts,GBVIEW_PLANE * p,int x,int y);
int call_wf_zoom(FLAME_SWITCH * sw,GBVIEW_PLANE * p,REAL1 zoom);
int call_wf_move(FLAME_SWITCH * sw,I_POINT from,I_POINT to);
int call_wf_rotate(FLAME_SWITCH * sw,GB_POINT from,GB_POINT to);
int call_wf_redraw(FLAME_SWITCH * sw,GBVIEW_PLANE * p,int x,int y,int w,int h);
void call_wf_indicate(FLAME_SWITCH * sw,GBVIEW_STATUS * sts,int x,int y,int button);
int call_wf_purge_select(FLAME_SWITCH * sw);
void call_wf_get_coordinate_info(FLAME_SWITCH * sw,L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len);
int call_wf_set_flame_switch(
	FLAME_SWITCH * sw,
	int mode,
	L_CHAR * url,
	L_CHAR * parameter,
	L_CHAR * peripheral,
	L_CHAR * format,
	L_CHAR * quality);
int call_wf_set_overlay(FLAME_SWITCH * sw,L_CHAR * u,int flags,int mask);
QUERY_THREAD * call_wf_radar_get_query(const FLAME_SWITCH *);
int call_wf_radar_set_query(const FLAME_SWITCH *,QUERY_THREAD *);
int call_wf_radar_replace_query(const FLAME_SWITCH *,QUERY_THREAD *);
int call_wf_radar_insert_query(const FLAME_SWITCH *,QUERY_THREAD *);
int call_wf_radar_delete_query(const FLAME_SWITCH *,int);
int
call_wf_radar_set_indicate_event(FLAME_SWITCH * sw,
	void (*func)(RADAR_INDICATE*,void*),
	void * work);
int
call_wf_radar_set_condition_event(FLAME_SWITCH * sw,
	void (*func)(QUERY_THREAD*,void*),
	void * work);
void init_gv_flame_switch(XLISP_ENV * env);
FLAME_SWITCH * _search_sw_id(int id);
void _insert_sw_hash(FLAME_SWITCH * sw);
void _delete_sw_hash(FLAME_SWITCH * sw);
FLAME_SWITCH * search_sw_id(int id);
void insert_sw_hash(FLAME_SWITCH * sw);
void delete_sw_hash(FLAME_SWITCH * sw);
void gvagent_redraw(FLAME_SWITCH * sw);
XL_SEXP * n_get_symbol_with_fid(const FLAME_SWITCH * sw, char * name);
XL_SEXP *  n_get_symbol_with_format(const FLAME_SWITCH * sw, char * name);
void init_gv_flame_switch(XLISP_ENV * env);
int call_wf_radar_warp(FLAME_SWITCH * sw,
	int type,
	GB_RECT * rect,
	GB_POINT * center,
	REAL1 resolution,
	REAL1 rotate,
	L_CHAR * target,
	WARP_POINT * wp,
	int tmp_flag);
int call_wf_loading_status(const FLAME_SWITCH * sw,LOADING_STATUS * ls);
int
call_wf_radar_set_history_event(FLAME_SWITCH * sw,
	void (*func)(RADAR_CACHE *,int,void*),
	void * work);
int
call_wf_radar_next_history(FLAME_SWITCH * sw);
int
call_wf_radar_prev_history(FLAME_SWITCH * sw);
int
call_wf_radar_insert_history(FLAME_SWITCH * sw);
WARP_POINT*
call_rc_get_warp_point(FLAME_SWITCH * sw,int type);
BIB_LIST*
call_gv_get_biblist(FLAME_SWITCH * sw,L_CHAR * url);

#ifdef __cplusplus
}
#endif

#endif
