/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "u_history.h"

#ifdef DEF_U_HISTORY

void
new_u_history(U_HISTORY * h)
{
	h->head = h->tail = 0;
}


void
free_u_history(U_HISTORY * h)
{
U_HISTORY_LIST * l_1,* l_2;
	for ( l_1 = h->head ; l_1 ; ) {
		l_2 = l_1->next;
		free(l_1);
		l_1 = l_2;
	}
	h->head = h->tail = 0;
}

void
set_u_history(U_HISTORY * h,int len)
{
U_HISTORY_LIST * lst;

	lst = malloc(sizeof(*lst));
	lst->len = len;
	lst->next = 0;
	if ( h->head ) {
		h->tail->next = lst;
		h->tail = lst;
	}
	else	h->head = h->tail = lst;
}

int *
get_u_history(U_HISTORY * h)
{
int * ret;
int len,i;
U_HISTORY_LIST * lst;
	for ( len = 0 , lst = h->head ; lst ; len ++ , lst = lst->next );
	ret = malloc(sizeof(int)*(len+1));
	ret[0] = len;
	for ( i = 1 , lst = h->head ; lst ; i ++ , lst = lst->next )
		ret[i] = lst->len;
	return ret;
}

#else

void
new_u_history(U_HISTORY * h)
{
}


void
free_u_history(U_HISTORY * h)
{
}

void
set_u_history(U_HISTORY * h,int len)
{
}

int *
get_u_history(U_HISTORY * h)
{
int * ret;
	ret = malloc(sizeof(int));
	ret[0] = 0;
	return ret;
}

#endif


