/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_FILE_H___
#define VPF_FILE_H___

#include "machine/include.h"
#include "vpf_table.h"
#include "vpf_types.h"
#include "vpf_container.h"

void vpf_read_field(void *ret, FILE *fp, VPF_COL *col, BOOL alloc_dest);
LONG vpf_read_long(FILE *fp);
SHORT vpf_read_short(FILE *fp);

TRIPLET_ID vpf_read_triplet(FILE *fp);
TRIPLET_ID vpf_read_ki(FILE *fp, VPF_COL *col);
LONG_FLOAT vpf_read_long_float(FILE *fp);
SHORT_FLOAT vpf_read_short_float(FILE *fp);
void vpf_read_text(char **dst, FILE *fp);

void vpf_read_coordinate(VPF_COORDINATE *ret, FILE *fp, VPF_COL *ci);
int vpf_read_coordinates(VPF_LIST *ret, FILE *fp, VPF_COL *ci);
void vpf_read_date(VPF_DATE *date, FILE *fp);

#define VPF_RECORD_READER_BEGIN(func_name, record_type) \
BOOL func_name(  \
	VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info) \
{                                      \
                                       \
VPF_LIST *records;                     \
VPF_LIST_ITEM *i;                      \
VPF_COL *c;                            \
record_type *r;                        \
                                       \
	records = table->records;          \
	r = (record_type *)calloc(sizeof(record_type),1);          \
	                                   \
	i = cols_info->head;               \
	c = (VPF_COL*)i->data;

#define VPF_READ_FIELD(field_name) \
	if(strcmp(c->name, #field_name)==0){ \
		vpf_read_field(&(r->field_name), fp, c, FALSE); \
		i = i->next; \
		if(i) c = (VPF_COL*)i->data; \
	} else{}

#define VPF_READ_VARIABLE_TEXT_FIELD(field_name) \
	if(strcmp(c->name, #field_name)==0){ \
		vpf_read_field(&(r->field_name), fp, c, TRUE); \
		i = i->next; \
		if(i) c = (VPF_COL*)i->data; \
	} else{}

#define VPF_READ_FIELD_MULTI(field_name) \
	if(strchr(c->name, '.')){\
		{ \
			int j;\
			for(j=0; strstr(c->name, "." #field_name); ++j){\
				if(j<VPF_MAX_FEATURE_COL){\
					vpf_read_field(&(r->field_name[j]), fp, c, FALSE);\
				}\
				else{\
					printf("error: feature col count over buffer size. %s\n", c->name);\
				}\
				i = i->next; \
				c = (VPF_COL*)i->data; \
			}\
		}\
	}

#define VPF_RECORD_READER_END() \
	vpf_list_push(records, r); \
	return TRUE; \
}


#endif


