/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <math.h>
#include "vpf_std.h"
#include "vpf_util.h"
#include "vpf_types.h"

int readToNextSeparator(FILE * fp , char* buf , char separator, int buff_len){
	int i=0;
	char c;
	
	while( (c=fgetc(fp))!=0 ){
		if(--buff_len<0){
			break;
		}
		if(c == separator){
			buf[i] = '\0';
			break;
		}
		buf[i]=c;
		i++;
	}
	
	return i;
}

void vpf_max_rect_xy(VPF_RECT *ret, LONG_FLOAT x, LONG_FLOAT y)
{
	if(ret->is_null){
		ret->left = x;
		ret->top = y;
		ret->right = x;
		ret->bottom = y;
		ret->is_null = FALSE;
	}
	else{
		if(ret->left > x)
			ret->left = x;
		if(ret->right < x)
			ret->right = x;
		if(ret->top > y)
			ret->top = y;
		if(ret->bottom < y)
			ret->bottom = y;
	}
}

void vpf_max_rect(VPF_RECT *ret, const VPF_RECT *new_rect)
{
	if(ret->is_null){
		ret->left = new_rect->left;
		ret->top = new_rect->top;
		ret->right = new_rect->right;
		ret->bottom = new_rect->bottom;
	}
	else{
		if(ret->left > new_rect->left)
			ret->left = new_rect->left;
		if(ret->right < new_rect->right)
			ret->right = new_rect->right;
		if(ret->top > new_rect->top)
			ret->top = new_rect->top;
		if(ret->bottom < new_rect->bottom)
			ret->bottom = new_rect->bottom;
	}
	ret->is_null = FALSE;
}

void vpf_trim(char *str)
{
	while(*str){
		if(*str==' '){
			*str=0;
			break;
		}
		++str;
	}
}

BOOL vpf_coordinate_equals(const VPF_COORDINATE *lhs, const VPF_COORDINATE *rhs)
{
	if(
		fabs(lhs->x - rhs->x) < 0.000001 &&
		fabs(lhs->y - rhs->y) < 0.000001 &&
		fabs(lhs->z - rhs->z) < 0.000001){
		return TRUE;
	}
	else{
		return FALSE;
	}
}

