/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"xl.h"
#include	"matrix.h"

#define BASE_TYPE 	int

int mxt_sexp_get_size(MATRIX_DATA_TYPE *,void * d);
void * mxt_sexp_sexp2md(int * cpy,struct matrix_data_type*,XL_SEXP * s);
XL_SEXP * mxt_sexp_md2sexp(struct matrix_data_type*,void * d);
void * mxt_alloc_sexp_data(MATRIX_DATA_TYPE * tp,int,void * d,void * w,
	char*,int);
void mxt_sexp_panic();
void* mxt_sexp_panic_ptr();
int mxt_sexp_panic_int();
int mxt_sexp_cmp(MATRIX_DATA_TYPE * tp,void * s1,void * s2);
void mxt_free_sexp_data(struct matrix_data_type*,void *);

MATRIX_DATA_TYPE mx_type_sexp = {
	MDT_SEXP,
	"sexp",
	0,
	mxt_sexp_get_size,
	mxt_sexp_sexp2md,
	mxt_sexp_md2sexp,
	mxt_sexp_cmp,
	mxt_sexp_panic,
	mxt_sexp_panic_ptr,
	mxt_alloc_sexp_data,
	mxt_free_sexp_data,
	0,0,0,0,0,0,
	0,0,0,0,0
};


void
mxt_sexp_panic()
{
	er_panic("mx_type_sexp");
}

void *
mxt_sexp_panic_ptr()
{
	er_panic("mx_type_sexp");
	return 0;
}

int
mxt_sexp_panic_int()
{
	er_panic("mx_type_sexp");
	return 0;
}


int
mxt_sexp_get_size(MATRIX_DATA_TYPE * tp,void * d)
{
	return 0;
}


int
mxt_sexp_cmp(MATRIX_DATA_TYPE * tp,void * _s1,void * _s2)
{
MATRIX_SEXP * s1, * s2;
	s1 = _s1;
	s2 = _s2;
	return cmp_sexp(s1->data,s2->data);
}


void * 
mxt_sexp_sexp2md(int * cpy,struct matrix_data_type* tp,XL_SEXP * s)
{
MATRIX_SEXP * d;
	d = d_alloc(sizeof(*d));
	d->data = s;
	d->del = 0;
	d->gc_func = gc_gb_sexp;
	_insert_matrix_sexp(d);
	if ( cpy )
		*cpy = 1;
	return d;
}

XL_SEXP * 
mxt_sexp_md2sexp(struct matrix_data_type* tp,void * d)
{
MATRIX_SEXP * _d;
	_d = (MATRIX_SEXP *)d;
	cons(_d->data,0);
	return _d->data;
}

void * 
mxt_alloc_sexp_data(MATRIX_DATA_TYPE * tp,int atype,void * d,void * w,char* __f,int __l)
{
	return mxt_sexp_sexp2md(0,tp,(XL_SEXP*)d);
}

void 
mxt_free_sexp_data(struct matrix_data_type* tp ,void * d)
{
MATRIX_SEXP * _d;
	_d = (MATRIX_SEXP*)d;
	_d->del = 1;	
}




