/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	<stdlib.h>
#include	"stream.h"
#include	"xl2pdb_p.h"
#include	"avt.h"
#include	"svg2gb.h"
#include	"memory_debug.h"

extern PDB_POLYGON2D * pdb_p_list;
extern CODE_INDEX *code_index;
extern AVT_NODE * pdb_same_name_avt;
extern CODE_METHOD * data_encoding_cm;
extern char * data_encoding;
extern PDB_MARK_TAGS *pdb_mark_tags;

void output_pdb_mark_tags(STREAM *fd){
PDB_MARK_TAGS *mark;

	for(mark=pdb_mark_tags; mark; mark=mark->next){
		print_sexp(fd, mark->sexp, PF_XML|PF_INDENT);
		s_printf(fd,"\n");
		print_sexp(fd, mark->info, PF_XML|PF_INDENT);
		s_printf(fd,"\n");
	}
}

void set_mark_info_code()
{
PDB_MARK_TAGS *mark;
char buf[32];

	int code=256;
	for(mark=pdb_mark_tags; mark; mark=mark->next){
		sprintf(buf, "%d", code);
		mark->sexp->pair.car = replace_attribute(car(mark->sexp), l_string(std_cm, "code"), l_string(std_cm, buf));
		mark->info->pair.car = replace_attribute(car(mark->info), l_string(std_cm, "code"), l_string(std_cm, buf));
		code+=256;
	}
}

void set_mark_info_scheme(L_CHAR* scheme)
{
PDB_MARK_TAGS *mark;
static L_CHAR* const_scheme=0;
	if(const_scheme == 0){
		const_scheme = d_alloc((strlen("scheme")+1)*sizeof(L_CHAR));
		l_strcpy(const_scheme, l_string(std_cm, "scheme"));
	}
	
	for(mark=pdb_mark_tags; mark; mark=mark->next){
		set_attribute(car(mark->info), const_scheme, scheme);
	}
}

void
output_vct(SVG2GB_OUTPUTVCT_INFO *o)
{
STREAM * fd;
L_CHAR *scheme;
	fd = s_open_file(o->filename, O_RDWR|O_CREAT|O_TRUNC, 0644);
	if ( data_encoding_cm == 0 )
		er_panic("output_vct");
	s_set_cm(fd,data_encoding_cm);
	if ( fd < 0 ) {
		fprintf(stderr,"cannot open the file\n %s ", o->filename);
		exit(1);
	}
	
	set_mark_info_code();

	scheme = d_alloc( (strlen(o->scheme)+1) * sizeof(L_CHAR));
	l_strcpy(scheme, l_string(std_cm,o->scheme));
	set_mark_info_scheme(scheme);
	d_f_ree(scheme);

	s_printf(fd,"<?xml version=\"1.0\" encoding=\"%s\" ?>\n", data_encoding);
	s_printf(fd,"<vector>\n");
	s_printf(fd," <meta>\n");
	s_printf(fd,"  <file type=\"xl\" />\n");
    s_printf(fd," </meta>\n");
    s_printf(fd," <set-scheme scheme=\"%s\" onmap=\"%s\" card=\"%s\" onmap.type=\"text/xl\" card.type=\"text/xl\" />\n", 
    	o->scheme, o->onmap_file, o->card_file);
	s_printf(fd," <set-visible-resolution>\n");
	s_printf(fd," %s\n", o->visible_resolution);
	s_printf(fd," </set-visible-resolution>\n");
    
	output_pdb_mark_tags(fd);
	
	s_printf(fd, "</vector>\n");

	s_close(fd);
}
