/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_OpenAS();

void
init_OpenAS(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"OpenAS"),
		get_func_prim(xl_OpenAS,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_OpenAS(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * filename;
int oflags;
L_CHAR * encoding;
int ret;
	oflags = O_CREAT|O_TRUNC;
	encoding = l_string(std_cm,"UTF-8");
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"type")) == 0 ) {
			if ( l_strcmp(sf->data,l_string(std_cm,"new")) == 0 )
				oflags = O_CREAT|O_TRUNC;
			else if ( l_strcmp(sf->data,
					l_string(std_cm,"update")) == 0 )
				oflags = 0;
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"encoding"))
				== 0 ) {
			encoding = sf->data;
		}
	}
	filename = get_el(s,1);
	if ( get_type(filename) != XLT_STRING )
		goto type_missmatch;
	ret = open_associate(
		n_string(std_cm,filename->string.data),
		oflags|O_RDWR,0644,PF_USEFREELIST,FT_ADDRESS_LUMP,
		n_string(std_cm,encoding));
	if ( ret < 0 )
		goto cannot_open;
	return get_integer(ret,0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"OpenAS"),
		n_get_string("type missmatch"));
cannot_open:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"OpenAS"),
		n_get_string("cannot open the file"));
}

