// ===========================================================================
//	CColorView.h
// ===========================================================================

#ifndef _H_CColorView
#define _H_CColorView
#pragma once

#include <LControlView.h>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant

// ---------------------------------------------------------------------------

class	CColorView : public LControlView {
public:
	enum { class_ID		= FOUR_CHAR_CODE('Clrv'),
		   imp_class_ID	= FOUR_CHAR_CODE('iClv') };

						CColorView(
								LStream*			inStream,
								ClassIDT			inImpID = imp_class_ID);

						CColorView(
								const SPaneInfo&	inPaneInfo,
								const SViewInfo&	inViewInfo,
								bool				inListView = false,
								ClassIDT			inImpID = imp_class_ID);

	virtual				~CColorView();

	virtual bool		GetColor(RGBColor*			inColor) const;
	virtual void		SetColor(RGBColor*			outColor) const;
	
	void				SetActionCallback(void(*func)(EventModifiers,void*), void* arg)
		{
			mActionCallback = func;
			mActionArg = arg;
		}

	virtual void		Click( SMouseDownEvent& inMouseDown );

protected:
	void				(*mActionCallback)(EventModifiers,void *);
	void *				mActionArg;
};

PP_End_Namespace_PowerPlant


#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
