/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "machine/v_types2.h"
#include "v/VButton.h"

#include <LControlPane.h>
#include <LControlImp.h>

extern "C" {
#include "memory_debug.h"
#include "utils.h"
}
#include "machine/v_types.h"

void
VButton::destroy_do(VObject* nmp)
{
	nmp->remove_child_do(this);
	delete info;
	nmp->redraw();
}

VButton::~VButton()
{
	// implemented in sub class.
}

VExError
VButton::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	if ( flags & VSF_CALC_MIN ) {
		// min is calculated when desc is set
	}

	if ( flags & (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS) ) {
		v_set_descriptor(info, sts.descriptor, sts.ws, sts.fsize, sts.vert_desc, 0);

		Rect rect = {0,0,0,0};
		SInt16 baseLine;
		::GetBestControlRect(((LControlPane*)info)->GetControlImp()->GetMacControl(), &rect, &baseLine);
		sts.min_size = (VSize){rect.right-rect.left, rect.bottom-rect.top};
		err.subcode1 &= ~(VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS);
	}

	V_OP_END

	return err;
}

void
VButton::redraw(VRect *rect) const
{
	_V_OP_START()
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	V_OP_END
}
