/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "UStandardDialogs.h"

#include	"LDocument.h"
#include	"v/VChooseFile.h"

extern "C" {
#include	"utils.h"
#include	"memory_debug.h"
char * get_path_from_mac_fs(FSSpec inMacFSSpec, Boolean isFolder);
char * mac_string(LC_FONT * f,const L_CHAR * _str);




char *
v_choose_file(const L_CHAR *title, const char *default_path)
{
	PP_StandardDialogs::LFileChooser	chooser;
	FSSpec spec;

	NavDialogOptions*	options = chooser.GetDialogOptions();
	if (options != nil) {
		options->dialogOptionFlags =	kNavDefaultNavDlogOptions
										+ kNavSelectAllReadableItem;
		c2pstrcpy(options->windowTitle, title ? mac_string(0,title) : "");
	}

	if ( default_path ) {
		char * def = change_delim_str(default_path);
		StringPtr d = (StringPtr)d_alloc((strlen(def)+1));
		c2pstrcpy(d, def);
		if ( noErr == FSMakeFSSpec(0, 0, d, &spec) )
			chooser.SetDefaultLocation(spec, true);
		d_f_ree(d);
		d_f_ree(def);
	}

	if (chooser.AskOpenFile(LFileTypeList(fileTypes_All))) {
		chooser.GetFileSpec(1, spec);
		char * path = get_path_from_mac_fs(spec, false);
		char *ret = normalize_delim_str(path);
		d_f_ree(path);
		return ret;
	}
	return 0;
}

char *
v_save_as_file(const L_CHAR *title, const char *default_path)
{
	PP_StandardDialogs::LFileDesignator		designator;
	StringPtr name = 0;
	FSRef ref;
	FSSpec spec;
	NavDialogOptions*	options = designator.GetDialogOptions();
	if (options != nil) {
		c2pstrcpy(options->windowTitle, title ? mac_string(0,title) : "");
	}
	
	if ( default_path ) {
		char * def = change_delim_str(default_path);
		char *last_delim = def-1;
		for ( char *s = def; *s; s++ ) {
			if (*s == '/')
				last_delim = s;
		}
		if (last_delim != def-1)
			*last_delim = 0;
		last_delim++;
		
		Boolean dir = true;
		if ( noErr == FSPathMakeRef((UInt8*)def, &ref, &dir) &&
			 noErr == FSGetCatalogInfo(&ref, kFSCatInfoNone, 0, 0, &spec, 0) )
			designator.SetDefaultLocation(spec, true);
		
		name = (StringPtr)d_alloc((strlen(last_delim)+1));
		c2pstrcpy(name, last_delim);

		d_f_ree(def);
	}

	bool	askOK = designator.AskDesignateFile(name ? name : "\p");

	if (name)
		d_f_ree(name);

	if (askOK) {
		designator.GetFileSpec(spec);
		int name_len = spec.name[0];
		spec.name[0] = 0;	// spec of directory
		char * path = get_path_from_mac_fs(spec, true); // get directory path
		int len = strlen(path);
		path = (char*)d_re_alloc(path, len+name_len+1);
		spec.name[0] = name_len;						// revert to file spec
		p2cstrcpy(path+len, spec.name);					// marge file name
		char *ret = normalize_delim_str(path);
		d_f_ree(path);
		return ret;
	}
	return 0;
}

}
