/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VButton.h"
#include "VReflector.h"
#include "CClickCheckAttachment.h"

#include "LView.h"
#include "LRadioButton.h"

extern "C" void er_panic(char*);


VExError
VRadioButton::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	LRadioButton *v = new LRadioButton(paneInfo, msg_ValueChanged, Button_On);
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	v->AddListener(new VReflector(this));
	info = v;
	radio_group = 0;
	init_group_list();
	return nmp->add_child_do(this);
}

void
VRadioButton::destroy_do(VObject* nmp)
{
	// radio_group will be automatically deleted
	delete_group_list();
	VButton::destroy_do(nmp);
}

VRadioButton::~VRadioButton()
{
}


VExError
VRadioButton::get_status(VObjectStatus *s, int flags) const
{
	VExError err;
	V_OP_START_EX
	
	if ( flags & VSF_VALUE ) {
		s->value = (info->GetValue() == Button_On);
		flags &= ~VSF_VALUE;
	}
	err = initial_VExError(V_ER_NO_ERR,flags,0);
	
	err = merge_VExError_vstatus_type(err,VButton::get_status(s,flags));
	
	V_OP_END
	return err;
};

VExError
VRadioButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = initial_VExError(V_ER_NO_ERR,flags,0);

	if ( flags & VSF_VALUE ) {
		info->SetValue(s->value ? Button_On : Button_Off);
		flags &= ~VSF_VALUE;
		err.subcode1 &= ~VSF_VALUE;
	}

	err = merge_VExError_vstatus_type(err,VButton::set_status(s,flags));
	V_OP_END

	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_DESC | VSF_VERTD | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

void
VRadioButton::set_radio_group(VRadioButton *group)
{
	LRadioGroup * grp = group->get_radio_group();
	if ( radio_group == grp )
		return;

	if ( radio_group && radio_group->GetCurrentRadioID() == sts.id )
		delete radio_group;
	grp->AddRadio((LRadioButton*)info);
	radio_group = grp;
	insert_group_list(group);
};

VRadioGroupInfo
VRadioButton::get_radio_group()
{
	if ( radio_group == 0 ) {
		radio_group = new LRadioGroup;
		((LRadioButton*)info)->SetValue(Button_Off);
		((LRadioButton*)info)->SetValue(Button_On);
		radio_group->AddRadio((LRadioButton*)info);
	}
	return radio_group;
}
