/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<unistd.h>
#include	<sys/resource.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	<sys/param.h>
#include	"utils.h"
#include	"limits.h"

unsigned int
_get_fd_max()
{
struct rlimit rr;
	getrlimit(RLIMIT_NOFILE,&rr);
	return (unsigned int)rr.rlim_cur;
}

int
_set_fd_max(unsigned int max)
{
struct rlimit rr;
	rr.rlim_cur = rr.rlim_max = max;
	return setrlimit(RLIMIT_NOFILE,&rr);
}
