/**********************************************************************
 
	Copyright (C) 2003 
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"utils.h"

static FILE *fp_gbpo=NULL;

void
exit_stabilizer(char c)
{
	if(fp_gbpo == NULL){
		/* 
			er_panic("exit_stabilizer: fp_gbpo == NULL");
		*/
		return;
	}
	if(fputc(c,fp_gbpo) == EOF)
		er_panic("exit_stabilizer: can not write stab status");
	fflush(fp_gbpo);
	_pclose(fp_gbpo);
}

int
stabilizer(int *pargc, char ***pargv)
{
int argc;
char **argv;
int stab_status;
int i;
/*
{
	return 's';
}
*/
	argc = *pargc;
	argv = *pargv;
	
	if (argc>2 && strcmp(argv[1], "-stab")==0 ) {
		stab_status = (int)argv[2][0];
		*pargv = argv+2;
		*pargc = argc-2;
	}
	else{
		stab_status = 's';
	}

	fp_gbpo = _popen("gbpo.exe", "wt");
	
	if(_popen == NULL){
		er_panic("cannt open pipe to gbpo(observer process for stabilizer)");
	}
	fprintf(fp_gbpo, "%s\n", argv[0]);
	for(i=1;i<*pargc;++i){
		fprintf(fp_gbpo, "%s\n", (*pargv)[i]);
	}
	fprintf(fp_gbpo, "\n");
	fflush(fp_gbpo);
	return stab_status;
}