/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<fcntl.h>
#include	<stdlib.h>
#include	<errno.h>
#include	"init.h"
#include	"long_char.h"
#include	"stream.h"
#include	"memory_routine.h"
#include	"memory_debug.h"
#include	"xl.h"
#include	"utils.h"


extern XL_INTERPRETER * main_interpreter;
extern XL_INTERPRETER ** interpreter_hash;
extern SEM xli_lock;

void
xl_setup_file_nowait(int argc,char ** argv)
{
XLISP_ENV * env;
XL_INTERPRETER * xli;
int id;

	env = new_env(gblisp_top_env1);
/*
	if ( argv[1][0] == '+' ) {
		switch ( argv[1][1] ) {
		case 's':
			t = &s_socket_table;
			break;
		case 'p':
			t = &s_pipe_table;
			break;
		default:
			fprintf(stderr,"argument error (+)\n");
			exit(1);
		}

		xli = new_xl_interpreter();

		switch ( argv[1][2] ) {
		case '1':
			xli->inp = s_open_descripter(3,t);
			xli->out = xli->inp;
			break;
		case '2':
			xli->inp = s_open_descripter(3,t);
			xli->out = s_open_descripter(4,t);
			break;
		default:
			fprintf(stderr,"argument error (+)\n");
			exit(1);
		}
		xli->a_type = XLA_PIPE;
		xli->env = env;
		xli->err = 0;
		xli->environment = 0;
	}
*/

	if ( argc == 1 || (argc > 1 && strcmp(argv[1],"/") == 0) ) {
		switch ( recv_streams_len ) {
		default:
			xli = new_xl_interpreter();
			xli->inp = recv_streams[0];
			xli->out = recv_streams[1];
			break;
		case 1:
			xli = new_xl_interpreter();
			xli->inp = xli->out = recv_streams[0];
			break;
		case 0:
			goto from_filename;
		}
		xli->a_type = XLA_PIPE;
		xli->env = env;
		xli->err = 0;
		xli->environment = 0;
		goto next_setup;
	}
	else {
	L_CHAR * file1, * file2;
	from_filename:
		file1 = nl_copy_str(std_cm,argv[1]);
		file2 = get_script(0,file1);
		d_f_ree(file1);
		if ( file2 == 0 ) {
			fprintf(stderr,"cannot open shell argument(1) %s\n",
					argv[1]);
			exit(1);
		}
		set_script_path(file2);
		xli = new_xl_interpreter();
		xli->a_type = XLA_FILE;
		xli->env = env;
		xli->input_file_name = file2;
		if ( argc >= 3 ) {
			if ( strcmp(argv[2],"/") == 0 )
				goto next;
			xli->output_file_name 
				= nl_copy_str(std_cm,argv[2]);
		}
		if ( argc >= 4 ) {
			if ( strcmp(argv[3],"/") == 0 )
				goto next;
			xli->error_file_name 
				= nl_copy_str(std_cm,argv[3]);
		}
	next:
		xli->environment = 0;
	}

next_setup:


	id = setup_i(xli);

	if ( id < 0 ) {
		fprintf(stderr,"cannot open shell argument(2) %s (%i:%i)\n",
			argv[1],id,errno);
		exit(1);
	}
}

