/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___RECT_TREE_H___
#define ___RECT_TREE_H___

#include	"gbgraph.h"


typedef struct rt_obj_list {
	struct rt_obj_list * 	next;
	void *			obj;
	GB_RECT			r;
} RT_OBJ_LIST;

typedef union rect_ptr {
	struct rect_node *	node;
	RT_OBJ_LIST *		ol;
} RECT_PTR;

#define RN_TLX		0x01
#define RN_TLY		0x02
#define RN_BRX		0x04
#define RN_BRY		0x08
#define RN_INDEX_MAX	16

#define RNM_TLX_LOW	0x5555
#define RNM_TLX_HIGH	0xaaaa
#define RNM_TLY_LOW	0x3333
#define RNM_TLY_HIGH	0xcccc
#define RNM_BRX_LOW	0x0f0f
#define RNM_BRX_HIGH	0xf0f0
#define RNM_BRY_LOW	0x00ff
#define RNM_BRY_HIGH	0xff00

typedef struct rect_node {
	GB_RECT		min;
	GB_RECT		max;
	GB_RECT		avg;
	int		ntype;
		/* if 1 then object */
	RECT_PTR	ptr[RN_INDEX_MAX];
} RECT_NODE;

typedef struct rect_tree {
	GB_RECT		min;
	GB_RECT		max;
	int		ntype;
	RECT_PTR	ptr;
	GB_RECT *	(*get_minrect)();
} RECT_TREE;

void init_rect_tree(RECT_TREE * rt,GB_RECT * r,GB_RECT* (*func)());
void free_rt_obj_list(RT_OBJ_LIST * ol);
void insert_rect_tree(RECT_TREE * rt,void * obj);
RT_OBJ_LIST * search_rect_tree(RECT_TREE * rt,GB_RECT * min,GB_RECT * max);
void delete_rect_tree(RECT_TREE * rt,void * obj);
void _delete_rect_tree(RECT_TREE * rt,void * obj);

void free_rect_node(RECT_NODE * rn);
int rt_cmp(GB_RECT * min,GB_RECT * r,GB_RECT * max);
int rt_equ(GB_RECT * r1,GB_RECT * r2);
RECT_NODE * new_rect_node(GB_RECT* min,GB_RECT *max,GB_RECT *avg,int index);
RT_OBJ_LIST * new_rt_obj_list(void * obj,RT_OBJ_LIST * ol);
void _insert_rect_tree(RECT_TREE * rt,RECT_NODE * rn,RT_OBJ_LIST * ol2,
	int depth);
int get_index_mask(GB_RECT * min,GB_RECT * max,GB_RECT * avg);
RT_OBJ_LIST * _search_rect_node(RECT_TREE * rt,RECT_NODE * rn,
	GB_RECT * min,GB_RECT * max,RT_OBJ_LIST * ol);
void test_rect_tree(RECT_TREE * rt);
void _test_object(void*);


#endif

