/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_SEPARATOR_H___
#define ___V_SEPARATOR_H___

#include "v/VObject.h"

class VSeparator : public VObject
{
  public:
	enum { object_type = VO_SEPR };
	virtual unsigned	get_type() const { return object_type; }
	
	virtual VExError		get_status(VObjectStatus *, int flags) const;
	virtual VExError		set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;
	
  protected:
	virtual				~VSeparator();
	
	virtual void		destroy_do(VObject*);
};

class VHSeparator : public VSeparator
{
  public:
	enum { object_type = VO_HSPR };
	virtual unsigned	get_type() const { return object_type; }
	
	static VHSeparator*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VHSeparator*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VHSeparator*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
  protected:
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);

  private:
	static VObject *internal_new(){
		return new VHSeparator();
	}
};

class VVSeparator : public VSeparator
{
  public:
	enum { object_type = VO_VSPR };
	virtual unsigned	get_type() const { return object_type; }

	static VVSeparator*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VVSeparator*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VVSeparator*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}

  protected:
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp,void * arg);

  private:
	static VObject *internal_new(){
		return new VVSeparator();
	}
};

#endif
