/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"



L_CHAR *
cc_string(L_CHAR * str,LCZ_SET * set,int flags)
{
L_CHAR * ret;
	if ( str == 0 )
		return 0;
	ret = code_convert_with_combine(str,l_strlen(str),
			set,CBF_SRC_PLANE|CBF_DST_PLANE|flags);
	set_buffer(ret);
	return ret;
}

XL_SEXP *
convert_code(XL_SEXP * st,LCZ_SET * set,int flags)
{
XL_SEXP * ret, * _ret;
XL_SYM_FIELD * sf;

	switch ( get_type(st) ) {
	case XLT_NULL:
		return 0;
	case XLT_ERROR:
		return get_error(
			st->h.file,
			st->h.line,
			st->err.code,
			cc_string(st->err.func,set,flags),
			convert_code(st->err.data,set,flags));
	case XLT_PAIR:
		ret = 0;
		for ( ; get_type(st) == XLT_PAIR ; st = cdr(st) )
			ret = cons(convert_code(car(st),set,flags),ret);
		_ret = convert_code(st,set,flags);
		for ( ; get_type(ret) == XLT_PAIR ; ret = cdr(ret) )
			_ret = cons(car(ret),_ret);
		return _ret;
	case XLT_SYMBOL:
		ret = get_symbol(cc_string(st->symbol.data,set,flags));
		for ( sf = st->symbol.field ; sf ; sf = sf->next )
			set_attribute(ret,
				cc_string(sf->name,set,flags),
				cc_string(sf->data,set,flags));
		return ret;
	case XLT_STRING:
		return get_string(cc_string(st->string.data,set,flags));
	case XLT_INTEGER:
		return get_integer(st->integer.data,
				cc_string(st->integer.unit,set,flags));
	case XLT_FLOAT:
		return get_floating(st->floating.data,
				cc_string(st->floating.unit,set,flags));
	case XLT_FUNC:
	case XLT_PTR:
	case XLT_RAW:
	case XLT_ENV:
		return st;
	default:
		er_panic("ConvertCode");
	}
	return st;
}


